<?php

namespace RTMTrade\OpenCart\AdminApi\Model;


/**
 * Class ProductAttribute
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class ProductAttribute
{

    private ?int $id;

    /**
     * @var ProductAttributeDescription[]
     */
    private array $descriptions;

    /**
     * ProductAttribute constructor.
     * @param int|null $id
     * @param ProductAttributeDescription[] $descriptions
     */
    public function __construct(?int $id = null,
                                array $descriptions = [])
    {
        $this->id = $id;
        $this->descriptions = $descriptions;
    }


    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return ProductAttribute
     */
    public function setId(?int $id): ProductAttribute
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return ProductAttributeDescription[]
     */
    public function getDescriptions(): array
    {
        return $this->descriptions;
    }

    /**
     * @param ProductAttributeDescription[] $descriptions
     * @return ProductAttribute
     */
    public function setDescriptions(array $descriptions): ProductAttribute
    {
        $this->descriptions = $descriptions;
        return $this;
    }


}


