<?php


namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class OrderTotal
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class OrderTotal
{

    private ?int $id;
    private ?string $code;
    private ?string $title;
    private ?string $text;
    private ?float $value;

    /**
     * OrderTotal constructor.
     * @param int|null $id
     * @param string|null $code
     * @param string|null $title
     * @param string|null $text
     * @param float|null $value
     */
    public function __construct(?int $id = null,
                                ?string $code = null,
                                ?string $title = null,
                                ?string  $text = null,
                                ?float   $value = 0)
    {
        $this->id = $id;
        $this->code = $code;
        $this->title = $title;
        $this->text = $text;
        $this->value = $value;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return OrderTotal
     */
    public function setId(?int $id): OrderTotal
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string|null $code
     * @return OrderTotal
     */
    public function setCode(?string $code): OrderTotal
    {
        $this->code = $code;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @param string|null $title
     * @return OrderTotal
     */
    public function setTitle(?string $title): OrderTotal
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getText(): ?string
    {
        return $this->text;
    }

    /**
     * @param string|null $text
     * @return OrderTotal
     */
    public function setText(?string $text): OrderTotal
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getValue(): ?float
    {
        return $this->value;
    }

    /**
     * @param float|null $value
     * @return OrderTotal
     */
    public function setValue(?float $value): OrderTotal
    {
        $this->value = $value;
        return $this;
    }

}