<?php

namespace RTMTrade\OpenCart\AdminApi\Model;


class OrderProductOption
{
    private ?string $name;
    private ?string $value;
    private ?string $type;
    private ?int $productOptionId;
    private ?int $productOptionValueId;
    private ?int $optionId;
    private ?int $optionValueId;
    private ?string $ean;

    /**
     * OrderProductOption constructor.
     * @param string|null $name
     * @param string|null $value
     * @param string|null $type
     * @param int|null $productOptionId
     * @param int|null $productOptionValueId
     * @param int|null $optionId
     * @param int|null $optionValueId
     * @param string|null $ean
     */
    public function __construct(?string $name = null,
                                ?string $value = null,
                                ?string $type = null,
                                ?int    $productOptionId = null,
                                ?int    $productOptionValueId = null,
                                ?int    $optionId = null,
                                ?int    $optionValueId = null,
                                ?string $ean = null)
    {
        $this->name = $name;
        $this->value = $value;
        $this->type = $type;
        $this->productOptionId = $productOptionId;
        $this->productOptionValueId = $productOptionValueId;
        $this->optionId = $optionId;
        $this->optionValueId = $optionValueId;
        $this->ean = $ean;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return OrderProductOption
     */
    public function setName(?string $name): OrderProductOption
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     * @return OrderProductOption
     */
    public function setValue(?string $value): OrderProductOption
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->type;
    }

    /**
     * @param string|null $type
     * @return OrderProductOption
     */
    public function setType(?string $type): OrderProductOption
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getProductOptionId(): ?int
    {
        return $this->productOptionId;
    }

    /**
     * @param int|null $productOptionId
     * @return OrderProductOption
     */
    public function setProductOptionId(?int $productOptionId): OrderProductOption
    {
        $this->productOptionId = $productOptionId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getProductOptionValueId(): ?int
    {
        return $this->productOptionValueId;
    }

    /**
     * @param int|null $productOptionValueId
     * @return OrderProductOption
     */
    public function setProductOptionValueId(?int $productOptionValueId): OrderProductOption
    {
        $this->productOptionValueId = $productOptionValueId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getOptionId(): ?int
    {
        return $this->optionId;
    }

    /**
     * @param int|null $optionId
     * @return OrderProductOption
     */
    public function setOptionId(?int $optionId): OrderProductOption
    {
        $this->optionId = $optionId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getOptionValueId(): ?int
    {
        return $this->optionValueId;
    }

    /**
     * @param int|null $optionValueId
     * @return OrderProductOption
     */
    public function setOptionValueId(?int $optionValueId): OrderProductOption
    {
        $this->optionValueId = $optionValueId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEan(): ?string
    {
        return $this->ean;
    }

    /**
     * @param string|null $ean
     * @return OrderProductOption
     */
    public function setEan(?string $ean): OrderProductOption
    {
        $this->ean = $ean;
        return $this;
    }


}


