<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class OrderCustomer
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class OrderCustomer
{

    private ?int $customerId;
    private ?string $firstname;
    private ?string $lastname;
    private ?string $email;
    private ?string $telephone;
    private ?string $fax;

    /**
     * OrderCustomer constructor.
     * @param int|null $customerId
     * @param string|null $firstname
     * @param string|null $lastname
     * @param string|null $email
     * @param string|null $telephone
     * @param string|null $fax
     */
    public function __construct(?int $customerId = 0,
                                ?string $firstname = null,
                                ?string $lastname = null,
                                ?string $email = null,
                                ?string $telephone = null,
                                ?string $fax = null)
    {
        $this->customerId = $customerId;
        $this->firstname = $firstname;
        $this->lastname = $lastname;
        $this->email = $email;
        $this->telephone = $telephone;
        $this->fax = $fax;
    }

    public function getId(): ?int
    {
        return $this->customerId;
    }

    public function setId(?int $id): OrderCustomer
    {
        $this->customerId = $id;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getCustomerId(): ?int
    {
        return $this->customerId;
    }

    /**
     * @param int|null $customerId
     * @return OrderCustomer
     */
    public function setCustomerId(?int $customerId): OrderCustomer
    {
        $this->customerId = $customerId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    /**
     * @param string|null $firstname
     * @return OrderCustomer
     */
    public function setFirstname(?string $firstname): OrderCustomer
    {
        $this->firstname = $firstname;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    /**
     * @param string|null $lastname
     * @return OrderCustomer
     */
    public function setLastname(?string $lastname): OrderCustomer
    {
        $this->lastname = $lastname;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * @param string|null $email
     * @return OrderCustomer
     */
    public function setEmail(?string $email): OrderCustomer
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTelephone(): ?string
    {
        return $this->telephone;
    }

    /**
     * @param string|null $telephone
     * @return OrderCustomer
     */
    public function setTelephone(?string $telephone): OrderCustomer
    {
        $this->telephone = $telephone;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFax(): ?string
    {
        return $this->fax;
    }

    /**
     * @param string|null $fax
     * @return OrderCustomer
     */
    public function setFax(?string $fax): OrderCustomer
    {
        $this->fax = $fax;
        return $this;
    }

}


