<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

use DateTime;

/**
 * Class Order
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class Order
{
    /**
     * order_id
     * @var int|null
     */
    private ?int $id;

    private ?int $storeId;
    private ?string $storeName;
    private ?string $storeUrl;

    private ?int $affiliateId;

    private ?OrderInvoice $invoiceNumber;

    private ?string $comment;
    private ?string $status;
    private ?string $tracking;

    /**
     * todo: type?
     * @var array
     */
    private array $discounts;
    /**
     * todo: type?
     * @var array
     */
    private array $coupons;

    /**
     * @var OrderProduct[]
     */
    private array $products;

    /**
     * total
     * @var float|null
     */
    private ?float $totalPrice;
    private ?float $itemTotalTax;
    private ?float $itemTotalExcludeTax;
    private ?float $subtotal;

    /**
     * @var OrderTotal[]
     */
    private array $totals;

    private ?int $orderStatusId;

    private ?LanguageDescriptor $language;
    private ?SimpleCurrency $currency;
    private ?OrderHttpInfo $httpInfo;

    private ?OrderCustomer $customer;

    private ?MethodDescriptor $shippingMethod;
    private ?MethodDescriptor $paymentMethod;
    private ?Address $paymentAddress;
    private ?Address $shippingAddress;

    /**
     * Format: "Y-m-d H:i:s"
     * @var DateTime|null
     */
    private ?DateTime $dateAdded;

    /**
     * Format: "Y-m-d H:i:s"
     * @var DateTime|null
     */
    private ?DateTime $dateModified;

    /**
     * @var OrderStatusHistory[]
     */
    private array $histories;

    private ?string $atvpont;

    /**
     * Order constructor.
     * @param int|null $id
     * @param int|null $storeId
     * @param string|null $storeName
     * @param string|null $storeUrl
     * @param int|null $affiliateId
     * @param OrderInvoice|null $invoiceNumber
     * @param string|null $comment
     * @param string|null $status
     * @param string|null $tracking
     * @param array $discounts
     * @param array $coupons
     * @param array $products
     * @param float|null $totalPrice
     * @param float|null $itemTotalTax
     * @param float|null $itemTotalExcludeTax
     * @param float|null $subtotal
     * @param OrderTotal[] $totals
     * @param int|null $orderStatusId
     * @param LanguageDescriptor|null $language
     * @param SimpleCurrency|null $currency
     * @param OrderHttpInfo|null $httpInfo
     * @param OrderCustomer|null $customer
     * @param MethodDescriptor|null $shippingMethod
     * @param MethodDescriptor|null $paymentMethod
     * @param Address|null $paymentAddress
     * @param Address|null $shippingAddress
     * @param DateTime|null $dateAdded
     * @param DateTime|null $dateModified
     * @param OrderStatusHistory[] $histories
     * @param string|null $atvpont
     */
    public function __construct(?int $id = 0,
                                ?int $storeId = 0,
                                ?string $storeName = null,
                                ?string $storeUrl = null,
                                ?int $affiliateId = 0,
                                ?OrderInvoice $invoiceNumber = null,
                                ?string $comment = null,
                                ?string $status = null,
                                ?string $tracking = null,
                                array $discounts = [],
                                array $coupons = [],
                                array $products = [],
                                ?float $totalPrice = null,
                                ?float $itemTotalTax = null,
                                ?float $itemTotalExcludeTax = null,
                                ?float $subtotal = null,
                                array $totals = [],
                                ?int $orderStatusId = null,
                                ?LanguageDescriptor $language = null,
                                ?SimpleCurrency $currency = null,
                                ?OrderHttpInfo $httpInfo = null,
                                ?OrderCustomer $customer = null,
                                ?MethodDescriptor $shippingMethod = null,
                                ?MethodDescriptor $paymentMethod = null,
                                ?Address $paymentAddress = null,
                                ?Address $shippingAddress = null,
                                ?DateTime $dateAdded = null,
                                ?DateTime $dateModified = null,
                                array $histories = [],
                                ?string $atvpont = null)
    {
        $this->id = $id;
        $this->storeId = $storeId;
        $this->storeName = $storeName;
        $this->storeUrl = $storeUrl;
        $this->affiliateId = $affiliateId;
        $this->invoiceNumber = $invoiceNumber;
        $this->comment = $comment;
        $this->status = $status;
        $this->tracking = $tracking;
        $this->discounts = $discounts;
        $this->coupons = $coupons;
        $this->products = $products;
        $this->totalPrice = $totalPrice;
        $this->itemTotalTax = $itemTotalTax;
        $this->itemTotalExcludeTax = $itemTotalExcludeTax;
        $this->subtotal = $subtotal;
        $this->totals = $totals;
        $this->orderStatusId = $orderStatusId;
        $this->language = $language;
        $this->currency = $currency;
        $this->httpInfo = $httpInfo;
        $this->customer = $customer;
        $this->shippingMethod = $shippingMethod;
        $this->paymentMethod = $paymentMethod;
        $this->paymentAddress = $paymentAddress;
        $this->shippingAddress = $shippingAddress;
        $this->dateAdded = $dateAdded;
        $this->dateModified = $dateModified;
        $this->histories = $histories;
        $this->atvpont = $atvpont;
    }


    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return Order
     */
    public function setId(?int $id): Order
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getStoreId(): ?int
    {
        return $this->storeId;
    }

    /**
     * @param int|null $storeId
     * @return Order
     */
    public function setStoreId(?int $storeId): Order
    {
        $this->storeId = $storeId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getComment(): ?string
    {
        return $this->comment;
    }

    /**
     * @param string|null $comment
     * @return Order
     */
    public function setComment(?string $comment): Order
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     * @return Order
     */
    public function setStatus(?string $status): Order
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAffiliateId(): ?string
    {
        return $this->affiliateId;
    }

    /**
     * @param string|null $affiliateId
     * @return Order
     */
    public function setAffiliateId(?string $affiliateId): Order
    {
        $this->affiliateId = $affiliateId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTracking(): ?string
    {
        return $this->tracking;
    }

    /**
     * @param string|null $tracking
     * @return Order
     */
    public function setTracking(?string $tracking): Order
    {
        $this->tracking = $tracking;
        return $this;
    }

//    /**
//     * @return string|null
//     */
//    public function getVoucher(): ?string
//    {
//        return $this->voucher;
//    }
//
//    /**
//     * @param string|null $voucher
//     * @return Order
//     */
//    public function setVoucher(?string $voucher): Order
//    {
//        $this->voucher = $voucher;
//        return $this;
//    }

//    /**
//     * @return string|null
//     */
//    public function getCoupon(): ?string
//    {
//        return $this->coupon;
//    }
//
//    /**
//     * @param string|null $coupon
//     * @return Order
//     */
//    public function setCoupon(?string $coupon): Order
//    {
//        $this->coupon = $coupon;
//        return $this;
//    }

    /**
     * @return array
     */
    public function getProducts(): array
    {
        return $this->products;
    }

    /**
     * @param array $products
     * @return Order
     */
    public function setProducts(array $products): Order
    {
        $this->products = $products;
        return $this;
    }

    /**
     * @return OrderCustomer|null
     */
    public function getCustomer(): ?OrderCustomer
    {
        return $this->customer;
    }

    /**
     * @param OrderCustomer|null $customer
     * @return Order
     */
    public function setCustomer(?OrderCustomer $customer): Order
    {
        $this->customer = $customer;
        return $this;
    }

    /**
     * @return MethodDescriptor|null
     */
    public function getShippingMethod(): ?MethodDescriptor
    {
        return $this->shippingMethod;
    }

    /**
     * @param MethodDescriptor|null $shippingMethod
     * @return Order
     */
    public function setShippingMethod(?MethodDescriptor $shippingMethod): Order
    {
        $this->shippingMethod = $shippingMethod;
        return $this;
    }

    /**
     * @return MethodDescriptor|null
     */
    public function getPaymentMethod(): ?MethodDescriptor
    {
        return $this->paymentMethod;
    }

    /**
     * @param MethodDescriptor|null $paymentMethod
     * @return Order
     */
    public function setPaymentMethod(?MethodDescriptor $paymentMethod): Order
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }

    /**
     * @return Address|null
     */
    public function getPaymentAddress(): ?Address
    {
        return $this->paymentAddress;
    }

    /**
     * @param Address|null $paymentAddress
     * @return Order
     */
    public function setPaymentAddress(?Address $paymentAddress): Order
    {
        $this->paymentAddress = $paymentAddress;
        return $this;
    }

    /**
     * @return Address|null
     */
    public function getShippingAddress(): ?Address
    {
        return $this->shippingAddress;
    }

    /**
     * @param Address|null $shippingAddress
     * @return Order
     */
    public function setShippingAddress(?Address $shippingAddress): Order
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateAdded(): ?DateTime
    {
        return $this->dateAdded;
    }

    /**
     * @param DateTime|null $dateAdded
     * @return Order
     */
    public function setDateAdded(?DateTime $dateAdded): Order
    {
        $this->dateAdded = $dateAdded;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateModified(): ?DateTime
    {
        return $this->dateModified;
    }

    /**
     * @param DateTime|null $dateModified
     * @return Order
     */
    public function setDateModified(?DateTime $dateModified): Order
    {
        $this->dateModified = $dateModified;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStoreName(): ?string
    {
        return $this->storeName;
    }

    /**
     * @param string|null $storeName
     * @return Order
     */
    public function setStoreName(?string $storeName): Order
    {
        $this->storeName = $storeName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStoreUrl(): ?string
    {
        return $this->storeUrl;
    }

    /**
     * @param string|null $storeUrl
     * @return Order
     */
    public function setStoreUrl(?string $storeUrl): Order
    {
        $this->storeUrl = $storeUrl;
        return $this;
    }

    /**
     * @return OrderInvoice|null
     */
    public function getInvoiceNumber(): ?OrderInvoice
    {
        return $this->invoiceNumber;
    }

    /**
     * @param OrderInvoice|null $invoiceNumber
     * @return Order
     */
    public function setInvoiceNumber(?OrderInvoice $invoiceNumber): Order
    {
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }

    /**
     * @return array
     */
    public function getDiscounts(): array
    {
        return $this->discounts;
    }

    /**
     * @param array $discounts
     * @return Order
     */
    public function setDiscounts(array $discounts): Order
    {
        $this->discounts = $discounts;
        return $this;
    }

    /**
     * @return array
     */
    public function getCoupons(): array
    {
        return $this->coupons;
    }

    /**
     * @param array $coupons
     * @return Order
     */
    public function setCoupons(array $coupons): Order
    {
        $this->coupons = $coupons;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getTotalPrice(): ?float
    {
        return $this->totalPrice;
    }

    /**
     * @param float|null $totalPrice
     * @return Order
     */
    public function setTotalPrice(?float $totalPrice): Order
    {
        $this->totalPrice = $totalPrice;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getItemTotalTax(): ?float
    {
        return $this->itemTotalTax;
    }

    /**
     * @param float|null $itemTotalTax
     * @return Order
     */
    public function setItemTotalTax(?float $itemTotalTax): Order
    {
        $this->itemTotalTax = $itemTotalTax;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getItemTotalExcludeTax(): ?float
    {
        return $this->itemTotalExcludeTax;
    }

    /**
     * @param float|null $itemTotalExcludeTax
     * @return Order
     */
    public function setItemTotalExcludeTax(?float $itemTotalExcludeTax): Order
    {
        $this->itemTotalExcludeTax = $itemTotalExcludeTax;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getSubtotal(): ?float
    {
        return $this->subtotal;
    }

    /**
     * @param float|null $subtotal
     * @return Order
     */
    public function setSubtotal(?float $subtotal): Order
    {
        $this->subtotal = $subtotal;
        return $this;
    }

    /**
     * @return OrderTotal[]
     */
    public function getTotals(): array
    {
        return $this->totals;
    }

    /**
     * @param OrderTotal[] $totals
     * @return Order
     */
    public function setTotals(array $totals): Order
    {
        $this->totals = $totals;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getOrderStatusId(): ?int
    {
        return $this->orderStatusId;
    }

    /**
     * @param int|null $orderStatusId
     * @return Order
     */
    public function setOrderStatusId(?int $orderStatusId): Order
    {
        $this->orderStatusId = $orderStatusId;
        return $this;
    }

    /**
     * @return LanguageDescriptor|null
     */
    public function getLanguage(): ?LanguageDescriptor
    {
        return $this->language;
    }

    /**
     * @param LanguageDescriptor|null $language
     * @return Order
     */
    public function setLanguage(?LanguageDescriptor $language): Order
    {
        $this->language = $language;
        return $this;
    }

    /**
     * @return SimpleCurrency|null
     */
    public function getCurrency(): ?SimpleCurrency
    {
        return $this->currency;
    }

    /**
     * @param SimpleCurrency|null $currency
     * @return Order
     */
    public function setCurrency(?SimpleCurrency $currency): Order
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return OrderHttpInfo|null
     */
    public function getHttpInfo(): ?OrderHttpInfo
    {
        return $this->httpInfo;
    }

    /**
     * @param OrderHttpInfo|null $httpInfo
     * @return Order
     */
    public function setHttpInfo(?OrderHttpInfo $httpInfo): Order
    {
        $this->httpInfo = $httpInfo;
        return $this;
    }

    /**
     * @return OrderStatusHistory[]
     */
    public function getHistories(): array
    {
        return $this->histories;
    }

    /**
     * @param OrderStatusHistory[] $histories
     * @return Order
     */
    public function setHistories(array $histories): Order
    {
        $this->histories = $histories;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAtvpont(): ?string
    {
        return $this->atvpont;
    }

    /**
     * @param string|null $atvpont
     * @return Order
     */
    public function setAtvpont(?string $atvpont): Order
    {
        $this->atvpont = $atvpont;
        return $this;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function validate(): array
    {
        $invalidProperties = [];

        if ($this->products === null) {
            $invalidProperties[] = "'products' can't be null";
        }
        if ($this->shippingMethod === null) {
            $invalidProperties[] = "'shippingMethod' can't be null";
        }
        if ($this->paymentMethod === null) {
            $invalidProperties[] = "'paymentMethod' can't be null";
        }
        if ($this->paymentAddress === null) {
            $invalidProperties[] = "'paymentAddress' can't be null";
        }
        if ($this->shippingAddress === null) {
            $invalidProperties[] = "'shippingAddress' can't be null";
        }
        if ($this->customer === null) {
            $invalidProperties[] = "'customer' can't be null";
        }
        return $invalidProperties;
    }
}


