<?php


namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class MetaDescription
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class MetaDescription
{

    private ?int $id = null;
    private ?string $name;
    private ?string $description;
    private ?int $languageId;
    private ?string $metaDescription;
    private ?string $metaKeyword;
    private ?string $metaTitle;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return MetaDescription
     */
    public function setId(?int $id): MetaDescription
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return MetaDescription
     */
    public function setName(?string $name): MetaDescription
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     * @return MetaDescription
     */
    public function setDescription(?string $description): MetaDescription
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getLanguageId(): ?int
    {
        return $this->languageId;
    }

    /**
     * @param int|null $languageId
     * @return MetaDescription
     */
    public function setLanguageId(?int $languageId): MetaDescription
    {
        $this->languageId = $languageId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMetaDescription(): ?string
    {
        return $this->metaDescription;
    }

    /**
     * @param string|null $metaDescription
     * @return MetaDescription
     */
    public function setMetaDescription(?string $metaDescription): MetaDescription
    {
        $this->metaDescription = $metaDescription;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMetaKeyword(): ?string
    {
        return $this->metaKeyword;
    }

    /**
     * @param string|null $metaKeyword
     * @return MetaDescription
     */
    public function setMetaKeyword(?string $metaKeyword): MetaDescription
    {
        $this->metaKeyword = $metaKeyword;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMetaTitle(): ?string
    {
        return $this->metaTitle;
    }

    /**
     * @param string|null $metaTitle
     * @return MetaDescription
     */
    public function setMetaTitle(?string $metaTitle): MetaDescription
    {
        $this->metaTitle = $metaTitle;
        return $this;
    }

}