<?php
/**
 * CustomerGroup
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 *
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * CustomerGroup Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CustomerGroup
{

    private ?int $id;
    private ?int $sortOrder;
    private ?bool $approval;
    private ?string $name;
    private ?string $description;
    private ?int $languageId;

    /**
     * CustomerGroup constructor.
     * @param int|null $id
     * @param int|null $sortOrder
     * @param bool|null $approval
     * @param string|null $name
     * @param string|null $description
     * @param int|null $languageId
     */
    public function __construct(?int $id, ?int $sortOrder, ?bool $approval, ?string $name, ?string $description, ?int $languageId)
    {
        $this->id = $id;
        $this->sortOrder = $sortOrder;
        $this->approval = $approval;
        $this->name = $name;
        $this->description = $description;
        $this->languageId = $languageId;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return CustomerGroup
     */
    public function setId(?int $id): CustomerGroup
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getSortOrder(): ?int
    {
        return $this->sortOrder;
    }

    /**
     * @param int|null $sortOrder
     * @return CustomerGroup
     */
    public function setSortOrder(?int $sortOrder): CustomerGroup
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getApproval(): ?bool
    {
        return $this->approval;
    }

    /**
     * @param bool|null $approval
     * @return CustomerGroup
     */
    public function setApproval(?bool $approval): CustomerGroup
    {
        $this->approval = $approval;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return CustomerGroup
     */
    public function setName(?string $name): CustomerGroup
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDescription(): ?string
    {
        return $this->description;
    }

    /**
     * @param string|null $description
     * @return CustomerGroup
     */
    public function setDescription(?string $description): CustomerGroup
    {
        $this->description = $description;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getLanguageId(): ?int
    {
        return $this->languageId;
    }

    /**
     * @param int|null $languageId
     * @return CustomerGroup
     */
    public function setLanguageId(?int $languageId): CustomerGroup
    {
        $this->languageId = $languageId;
        return $this;
    }

}


