<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


use DateTime;

class Customer
{

    private ?int $id;
    private ?int $customerGroupId;

    private ?string $firstname;
    private ?string $lastname;
    private ?string $name;
    private ?string $email;
    private ?string $telephone;
    private ?bool $newsletter;
    private ?bool $status;
    private ?bool $approved;
    private ?bool $safe;

    private ?int $rewardPoints;

    private ?string $ip;

    private ?DateTime $dateAdded;

    /**
     * @var CustomField[]
     */
    private array $customFields;

    private array $affiliates;

    /**
     * @var Address[]
     */
    private array $addresses;

    /**
     * Customer constructor.
     * @param int|null $id
     * @param int|null $customerGroupId
     * @param string|null $firstname
     * @param string|null $lastname
     * @param string|null $name
     * @param string|null $email
     * @param string|null $telephone
     * @param bool|null $newsletter
     * @param bool|null $status
     * @param bool|null $approved
     * @param bool|null $safe
     * @param int|null $rewardPoints
     * @param string|null $ip
     * @param DateTime|null $dateAdded
     * @param CustomField[] $customFields
     * @param array $affiliates
     * @param Address[] $addresses
     */
    public function __construct(?int $id = 0,
                                ?int $customerGroupId = 0,
                                ?string $firstname = null,
                                ?string $lastname = null,
                                ?string $name = null,
                                ?string $email = null,
                                ?string $telephone = null,
                                ?bool $newsletter = null,
                                ?bool $status = null,
                                ?bool $approved = null,
                                ?bool $safe = null,
                                ?int $rewardPoints = null,
                                ?string $ip = null,
                                ?DateTime $dateAdded = null,
                                array $customFields = [],
                                array $affiliates = [],
                                array $addresses = [])
    {
        $this->id = $id;
        $this->customerGroupId = $customerGroupId;
        $this->firstname = $firstname;
        $this->lastname = $lastname;
        $this->name = $name;
        $this->email = $email;
        $this->telephone = $telephone;
        $this->newsletter = $newsletter;
        $this->status = $status;
        $this->approved = $approved;
        $this->safe = $safe;
        $this->rewardPoints = $rewardPoints;
        $this->ip = $ip;
        $this->dateAdded = $dateAdded;
        $this->customFields = $customFields;
        $this->affiliates = $affiliates;
        $this->addresses = $addresses;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return Customer
     */
    public function setId(?int $id): Customer
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getCustomerGroupId(): ?int
    {
        return $this->customerGroupId;
    }

    /**
     * @param int|null $customerGroupId
     * @return Customer
     */
    public function setCustomerGroupId(?int $customerGroupId): Customer
    {
        $this->customerGroupId = $customerGroupId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    /**
     * @param string|null $firstname
     * @return Customer
     */
    public function setFirstname(?string $firstname): Customer
    {
        $this->firstname = $firstname;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    /**
     * @param string|null $lastname
     * @return Customer
     */
    public function setLastname(?string $lastname): Customer
    {
        $this->lastname = $lastname;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return Customer
     */
    public function setName(?string $name): Customer
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * @param string|null $email
     * @return Customer
     */
    public function setEmail(?string $email): Customer
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTelephone(): ?string
    {
        return $this->telephone;
    }

    /**
     * @param string|null $telephone
     * @return Customer
     */
    public function setTelephone(?string $telephone): Customer
    {
        $this->telephone = $telephone;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getNewsletter(): ?bool
    {
        return $this->newsletter;
    }

    /**
     * @param bool|null $newsletter
     * @return Customer
     */
    public function setNewsletter(?bool $newsletter): Customer
    {
        $this->newsletter = $newsletter;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getStatus(): ?bool
    {
        return $this->status;
    }

    /**
     * @param bool|null $status
     * @return Customer
     */
    public function setStatus(?bool $status): Customer
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getApproved(): ?bool
    {
        return $this->approved;
    }

    /**
     * @param bool|null $approved
     * @return Customer
     */
    public function setApproved(?bool $approved): Customer
    {
        $this->approved = $approved;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getSafe(): ?bool
    {
        return $this->safe;
    }

    /**
     * @param bool|null $safe
     * @return Customer
     */
    public function setSafe(?bool $safe): Customer
    {
        $this->safe = $safe;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getRewardPoints(): ?int
    {
        return $this->rewardPoints;
    }

    /**
     * @param int|null $rewardPoints
     * @return Customer
     */
    public function setRewardPoints(?int $rewardPoints): Customer
    {
        $this->rewardPoints = $rewardPoints;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIp(): ?string
    {
        return $this->ip;
    }

    /**
     * @param string|null $ip
     * @return Customer
     */
    public function setIp(?string $ip): Customer
    {
        $this->ip = $ip;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateAdded(): ?DateTime
    {
        return $this->dateAdded;
    }

    /**
     * @param DateTime|null $dateAdded
     * @return Customer
     */
    public function setDateAdded(?DateTime $dateAdded): Customer
    {
        $this->dateAdded = $dateAdded;
        return $this;
    }

    /**
     * @return CustomField[]
     */
    public function getCustomFields(): array
    {
        return $this->customFields;
    }

    /**
     * @param CustomField[] $customFields
     * @return Customer
     */
    public function setCustomFields(array $customFields): Customer
    {
        $this->customFields = $customFields;
        return $this;
    }

    /**
     * @return array
     */
    public function getAffiliates(): array
    {
        return $this->affiliates;
    }

    /**
     * @param array $affiliates
     * @return Customer
     */
    public function setAffiliates(array $affiliates): Customer
    {
        $this->affiliates = $affiliates;
        return $this;
    }

    /**
     * @return Address[]
     */
    public function getAddresses(): array
    {
        return $this->addresses;
    }

    /**
     * @param Address[] $addresses
     * @return Customer
     */
    public function setAddresses(array $addresses): Customer
    {
        $this->addresses = $addresses;
        return $this;
    }

}


