<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

class ApiResponse
{
    private bool $success;
    private array $error;
    private $data;

    /**
     * ApiResponse constructor.
     */
    public function __construct()
    {
        $this->success = false;
        $this->error = [];
    }

    /**
     * @return bool
     */
    public function getSuccess(): bool
    {
        return $this->success;
    }

    /**
     * @param bool $success
     * @return ApiResponse
     */
    public function setSuccess(bool $success): ApiResponse
    {
        $this->success = $success;
        return $this;
    }

    /**
     * @return array
     */
    public function getError(): array
    {
        return $this->error;
    }

    /**
     * @param array $error
     * @return ApiResponse
     */
    public function setError(array $error): ApiResponse
    {
        $this->error = $error;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @param mixed $data
     * @return ApiResponse
     */
    public function setData($data): ApiResponse
    {
        $this->data = $data;
        return $this;
    }

}


