<?php
/**
 * Class1TokenApi
 * PHP version 5
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 *
 *
 * OpenAPI spec version: 1.0
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.15
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Api;

use AutoMapperPlus\Exception\UnregisteredMappingException;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\Psr7\Request;
use InvalidArgumentException;
use RTMTrade\OpenCart\AdminApi\ApiException;
use RTMTrade\OpenCart\AdminApi\Model\ApiResponse;
use RTMTrade\OpenCart\AdminApi\ObjectSerializer;
use RTMTrade\OpenCart\AdminApi\Token;

/**
 * Class1TokenApi Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TokenApi extends BaseHttpApi
{
    /**
     * Get access token
     *
     * @param string $authorization Authorization header value.&lt;br&gt;&lt;br&gt;&lt;b&gt;How to create Authorization header value:&lt;/b&gt;&lt;br&gt;&lt;ul&gt;&lt;li&gt;Concatenate the client id, a colon character \&quot;:\&quot;,and the client secret into a single string. So you’ll get &lt;code&gt;client_id:client_secret&lt;/code&gt;.&lt;/li&gt;&lt;li&gt;Base64 encode the concatenated string&lt;/li&gt;&lt;li&gt;Add \&quot;Basic \&quot; (including the space) before the encoded string.&lt;/li&gt;&lt;li&gt;If your client id is &lt;code&gt;demo_oauth_client&lt;/code&gt; and your client secret is &lt;code&gt;demo_oauth_secret&lt;/code&gt;, your concatenated string will be &lt;code&gt;demo_oauth_client:demo_oauth_secret&lt;/code&gt;. &lt;/li&gt;&lt;li&gt;After Base64 encode you will get &lt;code&gt;ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt; and the header parameter will be &lt;/li&gt;&lt;li&gt;&lt;code&gt;Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; (required)
     * @param string $grantType Grant type (required)
     *
     * @return ApiResponse
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function getToken(string $authorization, string $grantType): ApiResponse
    {
        [$response] = $this->getTokenWithHttpInfo($authorization, $grantType);
        return $this->mapper->map($response->getData(), Token::class);
    }

    /**
     * Get access token
     *
     * @param string $authorization Authorization header value.&lt;br&gt;&lt;br&gt;&lt;b&gt;How to create Authorization header value:&lt;/b&gt;&lt;br&gt;&lt;ul&gt;&lt;li&gt;Concatenate the client id, a colon character \&quot;:\&quot;,and the client secret into a single string. So you’ll get &lt;code&gt;client_id:client_secret&lt;/code&gt;.&lt;/li&gt;&lt;li&gt;Base64 encode the concatenated string&lt;/li&gt;&lt;li&gt;Add \&quot;Basic \&quot; (including the space) before the encoded string.&lt;/li&gt;&lt;li&gt;If your client id is &lt;code&gt;demo_oauth_client&lt;/code&gt; and your client secret is &lt;code&gt;demo_oauth_secret&lt;/code&gt;, your concatenated string will be &lt;code&gt;demo_oauth_client:demo_oauth_secret&lt;/code&gt;. &lt;/li&gt;&lt;li&gt;After Base64 encode you will get &lt;code&gt;ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt; and the header parameter will be &lt;/li&gt;&lt;li&gt;&lt;code&gt;Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; (required)
     * @param string $grantType Grant type (required)
     *
     * @return array of \RTMTrade\OpenCart\AdminApi\Model\ApiResponse, HTTP status code, HTTP response headers (array of strings)
     * @throws ApiException on non-2xx response
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function getTokenWithHttpInfo(string $authorization, string $grantType): array
    {
        $request = $this->createGetTokenRequest($authorization, $grantType);

        return $this->sendRequest($request);
    }

    /**
     * Create request for operation 'tokenGet'
     *
     * @param string $authorization Authorization header value.&lt;br&gt;&lt;br&gt;&lt;b&gt;How to create Authorization header value:&lt;/b&gt;&lt;br&gt;&lt;ul&gt;&lt;li&gt;Concatenate the client id, a colon character \&quot;:\&quot;,and the client secret into a single string. So you’ll get &lt;code&gt;client_id:client_secret&lt;/code&gt;.&lt;/li&gt;&lt;li&gt;Base64 encode the concatenated string&lt;/li&gt;&lt;li&gt;Add \&quot;Basic \&quot; (including the space) before the encoded string.&lt;/li&gt;&lt;li&gt;If your client id is &lt;code&gt;demo_oauth_client&lt;/code&gt; and your client secret is &lt;code&gt;demo_oauth_secret&lt;/code&gt;, your concatenated string will be &lt;code&gt;demo_oauth_client:demo_oauth_secret&lt;/code&gt;. &lt;/li&gt;&lt;li&gt;After Base64 encode you will get &lt;code&gt;ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt; and the header parameter will be &lt;/li&gt;&lt;li&gt;&lt;code&gt;Basic ZGVtb19vYXV0aF9jbGllbnQ6ZGVtb19vYXV0aF9zZWNyZXQ&#x3D;&lt;/code&gt;&lt;/li&gt;&lt;/ul&gt; (required)
     * @param string $grantType Grant type (required)
     *
     * @throws InvalidArgumentException
     * @return Request
     */
    protected function createGetTokenRequest(string $authorization, string $grantType): Request
    {
        $resourcePath = "/oauth2/token/{$grantType}";

        $headers = $this->headerSelector->selectHeaders(
            ['application/json'],
            []
        );

        // add user-agent header
        if ($this->config->getUserAgent()) {
            $headers['User-Agent'] = $this->config->getUserAgent();
        }

        $headers['Authorization'] = ObjectSerializer::toHeaderValue($authorization);

        return new Request('POST', $this->config->getBaseUrl() . $resourcePath, $headers);
    }
}
