<?php

namespace RTMTrade\OpenCart\AdminApi\Api;

use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Psr7\Uri;
use GuzzleHttp\Psr7\UriNormalizer;
use RTMTrade\OpenCart\AdminApi\ApiException;
use RTMTrade\OpenCart\AdminApi\Model\AttributeGroup;
use RTMTrade\OpenCart\AdminApi\Model\Category;
use RTMTrade\OpenCart\AdminApi\Model\Coupon;
use RTMTrade\OpenCart\AdminApi\Model\Customer;
use RTMTrade\OpenCart\AdminApi\Model\CustomerGroup;
use RTMTrade\OpenCart\AdminApi\Model\CustomField;
use RTMTrade\OpenCart\AdminApi\Model\FeaturedProduct;
use RTMTrade\OpenCart\AdminApi\Model\Manufacturer;
use RTMTrade\OpenCart\AdminApi\Model\Order;
use RTMTrade\OpenCart\AdminApi\Model\Product;
use RTMTrade\OpenCart\AdminApi\Model\ProductAttribute;
use RTMTrade\OpenCart\AdminApi\Model\ProductOptions;
use RTMTrade\OpenCart\AdminApi\Model\Store;
use RTMTrade\OpenCart\AdminApi\Model\Voucher;
use RTMTrade\OpenCart\AdminApi\ObjectSerializer;
use Throwable;

class SearchApi extends BaseHttpApi
{

    public const SEARCH_ROUTES = [
        Category::class => 'category_admin/category',
        Coupon::class => 'coupon_admin/coupon',
        CustomField::class => 'custom_field_admin/customfield',
        Customer::class => 'customer_admin/customers',
        CustomerGroup::class => 'customer_group_admin/customergroup',
        Manufacturer::class => 'manufacturer_admin/manufacturer',
        Order::class => 'order_admin/orders',
        ProductAttribute::class => 'attribute_admin/attribute',
        AttributeGroup::class => 'attribute_group_admin/attributegroup',
        FeaturedProduct::class => 'product_admin/features',
        ProductOptions::class => 'option_admin/option',
        Product::class => 'product_admin/products',
        Store::class => 'store_admin/store',
        Voucher::class => 'voucher_admin/vouchers'
    ];

    /**
     * @template T
     * @param class-string<T> $modelType
     * @param array $arguments
     * @return array<T>
     * @throws ApiException
     * @throws \AutoMapperPlus\Exception\UnregisteredMappingException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function search(string $modelType, array $arguments = [])
    {
        if (!isset(self::SEARCH_ROUTES[$modelType])) {
            throw new ApiException('No search route available for model type ' . $modelType);
        }

        $url = str_replace('api/rest_admin', 'index.php',
            $this->config->getBaseUrl());

        if ($modelType === Order::class && ($arguments['details'] ?? false) === true) {
            $route = 'order_admin/listorderswithdetails';
        } else {
            $route = self::SEARCH_ROUTES[$modelType];
        }

        ObjectSerializer::setDateTimeFormat('Y-m-d\TH:i:s');

        $uri = new Uri($url);
        $uri = Uri::withQueryValues($uri, array_merge(['route' => "rest/{$route}"], array_map(fn($a) => ObjectSerializer::toQueryValue($a), $arguments)));

        ObjectSerializer::setDateTimeFormat();

        $request = new Request('GET', $uri, $this->addDefaultHeaders(
            $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            ))
        );

        $response = $this->sendRequest($request);
        return $this->mapper->mapMultiple($response[0]->getData(), $modelType);
    }

}