<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


class StoreStats
{

    private ?int $saleTotal;
    private ?int $orderTotal;
    private ?int $customerTotal;
    private ?int $productTotal;

    /**
     * StoreStats constructor.
     * @param int|null $saleTotal
     * @param int|null $orderTotal
     * @param int|null $customerTotal
     * @param int|null $productTotal
     */
    public function __construct(?int $saleTotal = 0,
                                ?int $orderTotal = 0,
                                ?int $customerTotal = 0,
                                ?int $productTotal = 0)
    {
        $this->saleTotal = $saleTotal;
        $this->orderTotal = $orderTotal;
        $this->customerTotal = $customerTotal;
        $this->productTotal = $productTotal;
    }

    /**
     * @return int|null
     */
    public function getSaleTotal(): ?int
    {
        return $this->saleTotal;
    }

    /**
     * @param int|null $saleTotal
     * @return StoreStats
     */
    public function setSaleTotal(?int $saleTotal): StoreStats
    {
        $this->saleTotal = $saleTotal;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getOrderTotal(): ?int
    {
        return $this->orderTotal;
    }

    /**
     * @param int|null $orderTotal
     * @return StoreStats
     */
    public function setOrderTotal(?int $orderTotal): StoreStats
    {
        $this->orderTotal = $orderTotal;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getCustomerTotal(): ?int
    {
        return $this->customerTotal;
    }

    /**
     * @param int|null $customerTotal
     * @return StoreStats
     */
    public function setCustomerTotal(?int $customerTotal): StoreStats
    {
        $this->customerTotal = $customerTotal;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getProductTotal(): ?int
    {
        return $this->productTotal;
    }

    /**
     * @param int|null $productTotal
     * @return StoreStats
     */
    public function setProductTotal(?int $productTotal): StoreStats
    {
        $this->productTotal = $productTotal;
        return $this;
    }

}