<?php


namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class Currency
 * Represents a Opencart currency entry.
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class SimpleCurrency
{

    private ?int $id;
    private ?string $code;
    private ?string $value;

    /**
     * Currency constructor.
     * @param int|null $id
     * @param string|null $code
     * @param string|null $value
     */
    public function __construct(?int $id = null,
                                ?string $code = null,
                                ?string $value = null)
    {
        $this->id = $id;
        $this->code = $code;
        $this->value = $value;
    }


    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return SimpleCurrency
     */
    public function setId(?int $id): SimpleCurrency
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string|null $code
     * @return SimpleCurrency
     */
    public function setCode(?string $code): SimpleCurrency
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     * @return SimpleCurrency
     */
    public function setValue(?string $value): SimpleCurrency
    {
        $this->value = $value;
        return $this;
    }

}