<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


/**
 * Class OrderStatusHistory
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class PutOrderStatusHistory
{

    private ?int $notify;
    private ?int $orderStatusId;
    private ?string $comment;

    /**
     * OrderStatusHistory constructor.
     * @param int|null $notify
     * @param string|null $orderStatusId
     * @param string|null $comment
     */
    public function __construct(?int   $notify = null,
                                ?int $orderStatusId = null,
                                ?string $comment = null)
    {
        $this->notify = $notify;
        $this->orderStatusId = $orderStatusId;
        $this->comment = $comment;
    }


    /**
     * @return int|null
     */
    public function getNotify(): ?int
    {
        return $this->notify;
    }

    /**
     * @param int|null $notify
     * @return PutOrderStatusHistory
     */
    public function setNotify(?int $notify): PutOrderStatusHistory
    {
        $this->notify = $notify;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getStatus(): ?int
    {
        return $this->orderStatusId;
    }

    /**
     * @param int|null $status
     * @return PutOrderStatusHistory
     */
    public function setStatus(?int $status): PutOrderStatusHistory
    {
        $this->orderStatusId = $status;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getComment(): ?string
    {
        return $this->comment;
    }

    /**
     * @param string|null $comment
     * @return PutOrderStatusHistory
     */
    public function setComment(?string $comment): PutOrderStatusHistory
    {
        $this->comment = $comment;
        return $this;
    }

}