<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

use DateTime;

/**
 * Class ProductSpecial
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class ProductSpecial
{

    private ?int $customerGroupId;
    private ?float $price;
    private ?int $priority;
    private ?DateTime $dateStart;
    private ?DateTime $dateEnd;

    /**
     * @return int|null
     */
    public function getCustomerGroupId(): ?int
    {
        return $this->customerGroupId;
    }

    /**
     * @param int|null $customerGroupId
     * @return ProductSpecial
     */
    public function setCustomerGroupId(?int $customerGroupId): ProductSpecial
    {
        $this->customerGroupId = $customerGroupId;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getPrice(): ?float
    {
        return $this->price;
    }

    /**
     * @param float|null $price
     * @return ProductSpecial
     */
    public function setPrice(?float $price): ProductSpecial
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getPriority(): ?int
    {
        return $this->priority;
    }

    /**
     * @param int|null $priority
     * @return ProductSpecial
     */
    public function setPriority(?int $priority): ProductSpecial
    {
        $this->priority = $priority;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateStart(): ?DateTime
    {
        return $this->dateStart;
    }

    /**
     * @param DateTime|null $dateStart
     * @return ProductSpecial
     */
    public function setDateStart(?DateTime $dateStart): ProductSpecial
    {
        $this->dateStart = $dateStart;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateEnd(): ?DateTime
    {
        return $this->dateEnd;
    }

    /**
     * @param DateTime|null $dateEnd
     * @return ProductSpecial
     */
    public function setDateEnd(?DateTime $dateEnd): ProductSpecial
    {
        $this->dateEnd = $dateEnd;
        return $this;
    }

}


