<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


class ProductCategory
{

    private int $id;

    /**
     * @var MetaDescription[]
     */
    private array $descriptions;

    /**
     * ProductCategory constructor.
     */
    public function __construct()
    {
        $this->id = 0;
        $this->descriptions = [];
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return ProductCategory
     */
    public function setId(int $id): ProductCategory
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return MetaDescription[]
     */
    public function getDescriptions(): array
    {
        return $this->descriptions;
    }

    /**
     * @param MetaDescription[] $descriptions
     * @return ProductCategory
     */
    public function setDescriptions(array $descriptions): ProductCategory
    {
        $this->descriptions = $descriptions;
        return $this;
    }

    public function addDescription(MetaDescription $description): ProductCategory
    {
        $this->descriptions[] = $description;
        return $this;
    }

}