<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

use DateTime;

/**
 * Product Class
 *
 * PHP model for the API response JSON of opencart-admin-api.
 *
 * @package  RTMTrade\OpenCart\AdminApi
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class Product
{
    private ?int $id;

    /*
     * Image fields
     */

    private ?string $image;
    private ?string $originalImage;

    /**
     * @var string[]
     */
    private array $images;
    /**
     * @var string[]
     */
    private array $originalImages;

    /*
     * Monetary fields
     */

    private ?float $price;
    /**
     * price_formated
     * @var string|null
     */
    private ?string $priceFormatted;
    private ?float $taxValue;
    private ?int $taxClassId;

    private ?SimpleCurrency $currency;

    /*
     * Meta fields
     */

    /**
     * Whether the product is enabled.
     * @var bool|string|null
     */
    private ?string $model;
    private ?bool $status;
    private ?string $manufacturer;
    private ?int $manufacturerId;

    private ?int $sortOrder;
    private ?float $rating;
    private ?int $viewed;

    /**
     * @var Keyword[]
     */
    private array $keyword;

    /**
     * product_relateds
     * @var int[]
     */
    private array $relatedProductIds;

    /**
     * @var int[]
     */
    private array $filters;

    /**
     * @var Review[]
     */
    private array $reviews;

    /**
     * @var ProductDescription[]
     */
    private array $productDescriptions;

    /**
     * @var ProductAttribute[]
     */
    private array $productAttributes;

    /**
     * @var ProductSpecial[]
     */
    private array $special;

    /**
     * @var ProductDiscount[]
     */
    private array $discounts;

    /**
     * @var ProductOptions[]
     */
    private array $options;

    /**
     * @var ProductCategory[]
     */
    private array $categories;

    /*
     * Identifiers
     */

    private ?string $sku;
    private ?string $upc;
    private ?string $ean;
    private ?string $jan;
    private ?string $isbn;
    private ?string $mpn;

    /*
     * Stock fields
     */

    /**
     * @var int[]
     */
    private array $stores;
    private ?string $location;
    private ?string $stockStatus;
    private ?int $stockStatusId;

    private ?int $quantity;

    /**
     * Minimum amount per order
     * @var int|null
     */
    private ?int $minimum;

    /**
     * Whether to subtract from stock when ordered
     * @var bool|int|null
     */
    private ?bool $subtract;

    /**
     * Whether shipping is required
     * @var bool
     */
    private ?bool $shipping;

    /*
     * Dimensions and weight
     */

    private ?float $weight;
    private ?int $weightClassId;
    private ?string $weightClass;

    private ?float $length;
    private ?int $lengthClassId;
    private ?string $lengthClass;
    private ?float $width;
    private ?float $height;

    /*
     * Dates
     */

    private ?DateTime $dateAvailable;
    private ?DateTime $dateAdded;
    private ?DateTime $dateModified;

    /*
     * Reward fields
     */

    private ?int $points;
    private ?int $reward;

    public function __construct()
    {
        $this->id = 0;
        $this->taxClassId = 0;
        $this->manufacturerId = 0;
        $this->stockStatusId = 0;
        $this->weightClassId = 0;
        $this->lengthClassId = 0;
        $this->sortOrder = 1;
        $this->quantity = 1;
        $this->minimum = 1;
        $this->image = null;
        $this->originalImage = null;
        $this->price = null;
        $this->priceFormatted = null;
        $this->taxValue = null;
        $this->currency = null;
        $this->model = null;
        $this->status = null;
        $this->manufacturer = null;
        $this->rating = null;
        $this->keyword = [];
        $this->viewed = null;
        $this->sku = null;
        $this->upc = null;
        $this->ean = null;
        $this->jan = null;
        $this->isbn = null;
        $this->mpn = null;
        $this->location = null;
        $this->stockStatus = null;
        $this->subtract = true;
        $this->shipping = true;
        $this->weight = null;
        $this->weightClass = null;
        $this->length = null;
        $this->lengthClass = null;
        $this->width = null;
        $this->height = null;
        $this->dateAvailable = null;
        $this->dateAdded = null;
        $this->dateModified = null;
        $this->points = null;
        $this->reward = null;
        $this->images = [];
        $this->originalImages = [];
        $this->relatedProductIds = [];
        $this->filters = [];
        $this->reviews = [];
        $this->productDescriptions = [];
        $this->productAttributes = [];
        $this->special = [];
        $this->discounts = [];
        $this->options = [];
        $this->categories = [];
        $this->stores = [];
    }


    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return Product
     */
    public function setId(?int $id): Product
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImage(): ?string
    {
        return $this->image;
    }

    /**
     * @param string|null $image
     * @return Product
     */
    public function setImage(?string $image): Product
    {
        $this->image = $image;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getOriginalImage(): ?string
    {
        return $this->originalImage;
    }

    /**
     * @param string|null $originalImage
     * @return Product
     */
    public function setOriginalImage(?string $originalImage): Product
    {
        $this->originalImage = $originalImage;
        return $this;
    }

    /**
     * @return string[]
     */
    public function getImages(): array
    {
        return $this->images;
    }

    /**
     * @param string[] $images
     * @return Product
     */
    public function setImages(array $images): Product
    {
        $this->images = $images;
        return $this;
    }

    /**
     * @return string[]
     */
    public function getOriginalImages(): array
    {
        return $this->originalImages;
    }

    /**
     * @param string[] $originalImages
     * @return Product
     */
    public function setOriginalImages(array $originalImages): Product
    {
        $this->originalImages = $originalImages;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getPrice(): ?float
    {
        return $this->price;
    }

    /**
     * @param float|null $price
     * @return Product
     */
    public function setPrice(?float $price): Product
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPriceFormatted(): ?string
    {
        return $this->priceFormatted;
    }

    /**
     * @param string|null $priceFormatted
     * @return Product
     */
    public function setPriceFormatted(?string $priceFormatted): Product
    {
        $this->priceFormatted = $priceFormatted;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getTaxValue(): ?float
    {
        return $this->taxValue;
    }

    /**
     * @param float|null $taxValue
     * @return Product
     */
    public function setTaxValue(?float $taxValue): Product
    {
        $this->taxValue = $taxValue;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getTaxClassId(): ?int
    {
        return $this->taxClassId;
    }

    /**
     * @param int|null $taxClassId
     * @return Product
     */
    public function setTaxClassId(?int $taxClassId): Product
    {
        $this->taxClassId = $taxClassId;
        return $this;
    }

    /**
     * @return SimpleCurrency
     */
    public function getCurrency(): SimpleCurrency
    {
        return $this->currency;
    }

    /**
     * @param SimpleCurrency $currency
     * @return Product
     */
    public function setCurrency(SimpleCurrency $currency): Product
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return bool|string|null
     */
    public function getModel()
    {
        return $this->model;
    }

    /**
     * @param bool|string|null $model
     * @return Product
     */
    public function setModel($model): Product
    {
        $this->model = $model;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getStatus(): ?bool
    {
        return $this->status;
    }

    /**
     * @param bool|null $status
     * @return Product
     */
    public function setStatus(?bool $status): Product
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getManufacturer(): ?string
    {
        return $this->manufacturer;
    }

    /**
     * @param string|null $manufacturer
     * @return Product
     */
    public function setManufacturer(?string $manufacturer): Product
    {
        $this->manufacturer = $manufacturer;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getManufacturerId(): ?int
    {
        return $this->manufacturerId;
    }

    /**
     * @param int|null $manufacturerId
     * @return Product
     */
    public function setManufacturerId(?int $manufacturerId): Product
    {
        $this->manufacturerId = $manufacturerId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getSortOrder(): ?int
    {
        return $this->sortOrder;
    }

    /**
     * @param int|null $sortOrder
     * @return Product
     */
    public function setSortOrder(?int $sortOrder): Product
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getRating(): ?float
    {
        return $this->rating;
    }

    /**
     * @param float|null $rating
     * @return Product
     */
    public function setRating(?float $rating): Product
    {
        $this->rating = $rating;
        return $this;
    }

    /**
     * @return string[]
     */
    public function getKeyword(): array
    {
        return $this->keyword;
    }

    /**
     * @param string[] $keyword
     * @return Product
     */
    public function setKeyword(array $keyword): Product
    {
        $this->keyword = $keyword;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getViewed(): ?int
    {
        return $this->viewed;
    }

    /**
     * @param int|null $viewed
     * @return Product
     */
    public function setViewed(?int $viewed): Product
    {
        $this->viewed = $viewed;
        return $this;
    }

    /**
     * @return int[]
     */
    public function getRelatedProductIds(): array
    {
        return $this->relatedProductIds;
    }

    /**
     * @param int[] $relatedProductIds
     * @return Product
     */
    public function setRelatedProductIds(array $relatedProductIds): Product
    {
        $this->relatedProductIds = $relatedProductIds;
        return $this;
    }

    /**
     * @return int[]
     */
    public function getFilters(): array
    {
        return $this->filters;
    }

    /**
     * @param int[] $filters
     * @return Product
     */
    public function setFilters(array $filters): Product
    {
        $this->filters = $filters;
        return $this;
    }

    /**
     * @return Review[]
     */
    public function getReviews(): array
    {
        return $this->reviews;
    }

    /**
     * @param Review[] $reviews
     * @return Product
     */
    public function setReviews(array $reviews): Product
    {
        $this->reviews = $reviews;
        return $this;
    }

    /**
     * @return ProductDescription[]
     */
    public function getProductDescriptions(): array
    {
        return $this->productDescriptions;
    }

    /**
     * @param ProductDescription[] $productDescriptions
     * @return Product
     */
    public function setProductDescriptions(array $productDescriptions): Product
    {
        $this->productDescriptions = $productDescriptions;
        return $this;
    }

    /**
     * @return ProductAttribute[]
     */
    public function getProductAttributes(): array
    {
        return $this->productAttributes;
    }

    /**
     * @param ProductAttribute[] $productAttributes
     * @return Product
     */
    public function setProductAttributes(array $productAttributes): Product
    {
        $this->productAttributes = $productAttributes;
        return $this;
    }

    /**
     * @return ProductSpecial[]
     */
    public function getSpecial(): array
    {
        return $this->special;
    }

    /**
     * @param ProductSpecial[] $special
     * @return Product
     */
    public function setSpecial(array $special): Product
    {
        $this->special = $special;
        return $this;
    }

    /**
     * @return ProductDiscount[]
     */
    public function getDiscounts(): array
    {
        return $this->discounts;
    }

    /**
     * @param ProductDiscount[] $discounts
     * @return Product
     */
    public function setDiscounts(array $discounts): Product
    {
        $this->discounts = $discounts;
        return $this;
    }

    /**
     * @return ProductOptions[]
     */
    public function getOptions(): array
    {
        return $this->options;
    }

    /**
     * @param ProductOptions[] $options
     * @return Product
     */
    public function setOptions(array $options): Product
    {
        $this->options = $options;
        return $this;
    }

    /**
     * @return ProductCategory[]
     */
    public function getCategories(): array
    {
        return $this->categories;
    }

    /**
     * @param ProductCategory[] $category
     * @return Product
     */
    public function setCategory(array $category): Product
    {
        $this->categories = $category;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSku(): ?string
    {
        return $this->sku;
    }

    /**
     * @param string|null $sku
     * @return Product
     */
    public function setSku(?string $sku): Product
    {
        $this->sku = $sku;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getUpc(): ?string
    {
        return $this->upc;
    }

    /**
     * @param string|null $upc
     * @return Product
     */
    public function setUpc(?string $upc): Product
    {
        $this->upc = $upc;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEan(): ?string
    {
        return $this->ean;
    }

    /**
     * @param string|null $ean
     * @return Product
     */
    public function setEan(?string $ean): Product
    {
        $this->ean = $ean;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getJan(): ?string
    {
        return $this->jan;
    }

    /**
     * @param string|null $jan
     * @return Product
     */
    public function setJan(?string $jan): Product
    {
        $this->jan = $jan;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIsbn(): ?string
    {
        return $this->isbn;
    }

    /**
     * @param string|null $isbn
     * @return Product
     */
    public function setIsbn(?string $isbn): Product
    {
        $this->isbn = $isbn;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMpn(): ?string
    {
        return $this->mpn;
    }

    /**
     * @param string|null $mpn
     * @return Product
     */
    public function setMpn(?string $mpn): Product
    {
        $this->mpn = $mpn;
        return $this;
    }

    /**
     * @return int[]
     */
    public function getStores(): array
    {
        return $this->stores;
    }

    /**
     * @param int[] $stores
     * @return Product
     */
    public function setStores(array $stores): Product
    {
        $this->stores = $stores;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLocation(): ?string
    {
        return $this->location;
    }

    /**
     * @param string|null $location
     * @return Product
     */
    public function setLocation(?string $location): Product
    {
        $this->location = $location;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStockStatus(): ?string
    {
        return $this->stockStatus;
    }

    /**
     * @param string|null $stockStatus
     * @return Product
     */
    public function setStockStatus(?string $stockStatus): Product
    {
        $this->stockStatus = $stockStatus;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getStockStatusId(): ?int
    {
        return $this->stockStatusId;
    }

    /**
     * @param int|null $stockStatusId
     * @return Product
     */
    public function setStockStatusId(?int $stockStatusId): Product
    {
        $this->stockStatusId = $stockStatusId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    /**
     * @param int|null $quantity
     * @return Product
     */
    public function setQuantity(?int $quantity): Product
    {
        $this->quantity = $quantity;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getMinimum(): ?int
    {
        return $this->minimum;
    }

    /**
     * @param int|null $minimum
     * @return Product
     */
    public function setMinimum(?int $minimum): Product
    {
        $this->minimum = $minimum;
        return $this;
    }

    /**
     * @return bool|int|null
     */
    public function getSubtract()
    {
        return $this->subtract;
    }

    /**
     * @param bool|int|null $subtract
     * @return Product
     */
    public function setSubtract($subtract): Product
    {
        $this->subtract = $subtract;
        return $this;
    }

    /**
     * @return bool
     */
    public function isShipping(): ?bool
    {
        return $this->shipping;
    }

    /**
     * @param bool $shipping
     * @return Product
     */
    public function setShipping(?bool $shipping): Product
    {
        $this->shipping = $shipping;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getWeight(): ?float
    {
        return $this->weight;
    }

    /**
     * @param float|null $weight
     * @return Product
     */
    public function setWeight(?float $weight): Product
    {
        $this->weight = $weight;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getWeightClassId(): ?int
    {
        return $this->weightClassId;
    }

    /**
     * @param int|null $weightClassId
     * @return Product
     */
    public function setWeightClassId(?int $weightClassId): Product
    {
        $this->weightClassId = $weightClassId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getWeightClass(): ?string
    {
        return $this->weightClass;
    }

    /**
     * @param string|null $weightClass
     * @return Product
     */
    public function setWeightClass(?string $weightClass): Product
    {
        $this->weightClass = $weightClass;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getLength(): ?float
    {
        return $this->length;
    }

    /**
     * @param float|null $length
     * @return Product
     */
    public function setLength(?float $length): Product
    {
        $this->length = $length;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getLengthClassId(): ?int
    {
        return $this->lengthClassId;
    }

    /**
     * @param int|null $lengthClassId
     * @return Product
     */
    public function setLengthClassId(?int $lengthClassId): Product
    {
        $this->lengthClassId = $lengthClassId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLengthClass(): ?string
    {
        return $this->lengthClass;
    }

    /**
     * @param string|null $lengthClass
     * @return Product
     */
    public function setLengthClass(?string $lengthClass): Product
    {
        $this->lengthClass = $lengthClass;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getWidth(): ?float
    {
        return $this->width;
    }

    /**
     * @param float|null $width
     * @return Product
     */
    public function setWidth(?float $width): Product
    {
        $this->width = $width;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getHeight(): ?float
    {
        return $this->height;
    }

    /**
     * @param float|null $height
     * @return Product
     */
    public function setHeight(?float $height): Product
    {
        $this->height = $height;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateAvailable(): ?DateTime
    {
        return $this->dateAvailable;
    }

    /**
     * @param DateTime|null $dateAvailable
     * @return Product
     */
    public function setDateAvailable(?DateTime $dateAvailable): Product
    {
        $this->dateAvailable = $dateAvailable;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateAdded(): ?DateTime
    {
        return $this->dateAdded;
    }

    /**
     * @param DateTime|null $dateAdded
     * @return Product
     */
    public function setDateAdded(?DateTime $dateAdded): Product
    {
        $this->dateAdded = $dateAdded;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateModified(): ?DateTime
    {
        return $this->dateModified;
    }

    /**
     * @param DateTime|null $dateModified
     * @return Product
     */
    public function setDateModified(?DateTime $dateModified): Product
    {
        $this->dateModified = $dateModified;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getPoints(): ?int
    {
        return $this->points;
    }

    /**
     * @param int|null $points
     * @return Product
     */
    public function setPoints(?int $points): Product
    {
        $this->points = $points;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getReward(): ?int
    {
        return $this->reward;
    }

    /**
     * @param int|null $reward
     * @return Product
     */
    public function setReward(?int $reward): Product
    {
        $this->reward = $reward;
        return $this;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function validate(): array
    {
        $invalidProperties = [];

        if ($this->model === null) {
            $invalidProperties[] = "'model' can't be null";
        }
        if (empty($this->productDescriptions)) {
            $invalidProperties[] = "'descriptions' can't be null";
        }
        return $invalidProperties;
    }

}


