<?php


namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class OrderTotal
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class OrderTotal
{

    private ?string $title;
    private ?string $text;
    private ?float $value;

    /**
     * OrderTotal constructor.
     * @param string|null $title
     * @param string|null $text
     * @param float|null $value
     */
    public function __construct(?string $title = null,
                                ?string $text = null,
                                ?float $value = 0)
    {
        $this->title = $title;
        $this->text = $text;
        $this->value = $value;
    }


    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @param string|null $title
     * @return OrderTotal
     */
    public function setTitle(?string $title): OrderTotal
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getText(): ?string
    {
        return $this->text;
    }

    /**
     * @param string|null $text
     * @return OrderTotal
     */
    public function setText(?string $text): OrderTotal
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getValue(): ?float
    {
        return $this->value;
    }

    /**
     * @param float|null $value
     * @return OrderTotal
     */
    public function setValue(?float $value): OrderTotal
    {
        $this->value = $value;
        return $this;
    }

}