<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


use DateTime;

/**
 * Class OrderStatusHistory
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class OrderStatusHistory
{

    private ?string $notify;
    private ?string $status;
    private ?string $comment;
    private ?DateTime $dateAdded;

    /**
     * OrderStatusHistory constructor.
     * @param string|null $notify
     * @param string|null $status
     * @param string|null $comment
     * @param DateTime|null $dateAdded
     */
    public function __construct(?string $notify = null,
                                ?string $status = null,
                                ?string $comment = null,
                                ?DateTime $dateAdded = null)
    {
        $this->notify = $notify;
        $this->status = $status;
        $this->comment = $comment;
        $this->dateAdded = $dateAdded;
    }


    /**
     * @return string|null
     */
    public function getNotify(): ?string
    {
        return $this->notify;
    }

    /**
     * @param string|null $notify
     * @return OrderStatusHistory
     */
    public function setNotify(?string $notify): OrderStatusHistory
    {
        $this->notify = $notify;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     * @return OrderStatusHistory
     */
    public function setStatus(?string $status): OrderStatusHistory
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getComment(): ?string
    {
        return $this->comment;
    }

    /**
     * @param string|null $comment
     * @return OrderStatusHistory
     */
    public function setComment(?string $comment): OrderStatusHistory
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getDateAdded(): ?DateTime
    {
        return $this->dateAdded;
    }

    /**
     * @param DateTime|null $dateAdded
     * @return OrderStatusHistory
     */
    public function setDateAdded(?DateTime $dateAdded): OrderStatusHistory
    {
        $this->dateAdded = $dateAdded;
        return $this;
    }


}