<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class MethodDescriptor
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class MethodDescriptor
{

    private ?string $title;
    private ?string $code;

    /**
     * ShippingMethod constructor.
     * @param string|null $title
     * @param string|null $code
     */
    public function __construct(?string $title = null,
                                ?string $code = null)
    {
        $this->title = $title;
        $this->code = $code;
    }


    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->title;
    }

    /**
     * @param string|null $title
     * @return MethodDescriptor
     */
    public function setTitle(?string $title): MethodDescriptor
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string|null $code
     * @return MethodDescriptor
     */
    public function setCode(?string $code): MethodDescriptor
    {
        $this->code = $code;
        return $this;
    }

}


