<?php


namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Class LanguageDescriptor
 * @package RTMTrade\OpenCart\AdminApi\Model
 * @author Beau Fiechter (RTM Business)
 * @link https://gitlab.rtmbusiness.nl/spyder/opencart-admin-api-php
 */
class LanguageDescriptor
{

    private ?int $id;
    private ?string $code;
    private ?string $filename;
    private ?string $directory;

    /**
     * LanguageDescriptor constructor.
     * @param int|null $id
     * @param string|null $code
     * @param string|null $filename
     * @param string|null $directory
     */
    public function __construct(?int $id = null,
                                ?string $code = null,
                                ?string $filename = null,
                                ?string $directory = null)
    {
        $this->id = $id;
        $this->code = $code;
        $this->filename = $filename;
        $this->directory = $directory;
    }

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return LanguageDescriptor
     */
    public function setId(?int $id): LanguageDescriptor
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCode(): ?string
    {
        return $this->code;
    }

    /**
     * @param string|null $code
     * @return LanguageDescriptor
     */
    public function setCode(?string $code): LanguageDescriptor
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilename(): ?string
    {
        return $this->filename;
    }

    /**
     * @param string|null $filename
     * @return LanguageDescriptor
     */
    public function setFilename(?string $filename): LanguageDescriptor
    {
        $this->filename = $filename;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDirectory(): ?string
    {
        return $this->directory;
    }

    /**
     * @param string|null $directory
     * @return LanguageDescriptor
     */
    public function setDirectory(?string $directory): LanguageDescriptor
    {
        $this->directory = $directory;
        return $this;
    }


}