<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


class Language
{

    private int $id;
    private string $name;
    private string $code;
    private string $locale;
    private string $image;
    private string $directory;
    private int $sortOrder;
    private bool $status;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return Language
     */
    public function setId(int $id): Language
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Language
     */
    public function setName(string $name): Language
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return Language
     */
    public function setCode(string $code): Language
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @param string $locale
     * @return Language
     */
    public function setLocale(string $locale): Language
    {
        $this->locale = $locale;
        return $this;
    }

    /**
     * @return string
     */
    public function getImage(): string
    {
        return $this->image;
    }

    /**
     * @param string $image
     * @return Language
     */
    public function setImage(string $image): Language
    {
        $this->image = $image;
        return $this;
    }

    /**
     * @return string
     */
    public function getDirectory(): string
    {
        return $this->directory;
    }

    /**
     * @param string $directory
     * @return Language
     */
    public function setDirectory(string $directory): Language
    {
        $this->directory = $directory;
        return $this;
    }

    /**
     * @return int
     */
    public function getSortOrder(): int
    {
        return $this->sortOrder;
    }

    /**
     * @param int $sortOrder
     * @return Language
     */
    public function setSortOrder(int $sortOrder): Language
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }

    /**
     * @return bool
     */
    public function isStatus(): bool
    {
        return $this->status;
    }

    /**
     * @param bool $status
     * @return Language
     */
    public function setStatus(bool $status): Language
    {
        $this->status = $status;
        return $this;
    }

}