<?php


namespace RTMTrade\OpenCart\AdminApi\Model;


class FeaturedProductModule
{

    private $id;
    private $name;
    private $code;

    /**
     * @var FeaturedProduct[]
     */
    private array $products;

    /**
     * FeaturedProductModule constructor.
     * @param $id
     * @param $name
     * @param $code
     * @param FeaturedProduct[] $products
     */
    public function __construct($id, $name, $code, array $products)
    {
        $this->id = $id;
        $this->name = $name;
        $this->code = $code;
        $this->products = $products;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     * @return FeaturedProductModule
     */
    public function setId($id): FeaturedProductModule
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param mixed $name
     * @return FeaturedProductModule
     */
    public function setName($name): FeaturedProductModule
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param mixed $code
     * @return FeaturedProductModule
     */
    public function setCode($code): FeaturedProductModule
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return FeaturedProduct[]
     */
    public function getProducts(): array
    {
        return $this->products;
    }

    /**
     * @param FeaturedProduct[] $products
     * @return FeaturedProductModule
     */
    public function setProducts(array $products): FeaturedProductModule
    {
        $this->products = $products;
        return $this;
    }


}