<?php

namespace RTMTrade\OpenCart\AdminApi\Model;

class CustomField
{

    private ?int $id;
    private array $customFieldValue;
    private ?string $name;
    private ?string $type;
    private ?string $value;
    private ?string $validation;
    private ?string $location;
    private ?bool $required;
    private ?int $sortOrder;

    /**
     * CustomerCustomField constructor.
     * @param int|null $id
     * @param array $customFieldValue
     * @param string|null $name
     * @param string|null $type
     * @param string|null $value
     * @param string|null $validation
     * @param string|null $location
     * @param bool|null $required
     * @param int|null $sortOrder
     */
    public function __construct(?int $id = null,
                                array $customFieldValue = [],
                                ?string $name = null,
                                ?string $type = null,
                                ?string $value = null,
                                ?string $validation = null,
                                ?string $location = null,
                                ?bool $required = null,
                                ?int $sortOrder = null)
    {
        $this->id = $id;
        $this->customFieldValue = $customFieldValue;
        $this->name = $name;
        $this->type = $type;
        $this->value = $value;
        $this->validation = $validation;
        $this->location = $location;
        $this->required = $required;
        $this->sortOrder = $sortOrder;
    }


    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return CustomField
     */
    public function setId(?int $id): CustomField
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return array
     */
    public function getCustomFieldValue(): array
    {
        return $this->customFieldValue;
    }

    /**
     * @param array $customFieldValue
     * @return CustomField
     */
    public function setCustomFieldValue(array $customFieldValue): CustomField
    {
        $this->customFieldValue = $customFieldValue;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string|null $name
     * @return CustomField
     */
    public function setName(?string $name): CustomField
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getType(): ?string
    {
        return $this->type;
    }

    /**
     * @param string|null $type
     * @return CustomField
     */
    public function setType(?string $type): CustomField
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     * @return CustomField
     */
    public function setValue(?string $value): CustomField
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getValidation(): ?string
    {
        return $this->validation;
    }

    /**
     * @param string|null $validation
     * @return CustomField
     */
    public function setValidation(?string $validation): CustomField
    {
        $this->validation = $validation;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLocation(): ?string
    {
        return $this->location;
    }

    /**
     * @param string|null $location
     * @return CustomField
     */
    public function setLocation(?string $location): CustomField
    {
        $this->location = $location;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getRequired(): ?bool
    {
        return $this->required;
    }

    /**
     * @param bool|null $required
     * @return CustomField
     */
    public function setRequired(?bool $required): CustomField
    {
        $this->required = $required;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getSortOrder(): ?int
    {
        return $this->sortOrder;
    }

    /**
     * @param int|null $sortOrder
     * @return CustomField
     */
    public function setSortOrder(?int $sortOrder): CustomField
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }

}


