<?php
/**
 * Category
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 *
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

/**
 * Category Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Category
{
    /**
     * @var MetaDescription[]
     */
    private array $categoryDescription;
    /**
     * @var int[]
     */
    private array $categoryStore;
    /**
     * @var int[]
     */
    private array $categoryFilter;
    private ?string $image;
    private ?int $sortOrder;
    private ?int $parentId;
    private ?string $status;
    private ?int $column; //todo: bool?
    private ?int $top; //todo: bool?
    private ?string $keyword;

    /**
     * Category constructor.
     * @param array $categoryDescription
     * @param array $categoryStore
     * @param array $categoryFilter
     * @param string|null $image
     * @param int|null $sortOrder
     * @param int|null $parentId
     * @param string|null $status
     * @param int|null $column
     * @param int|null $top
     * @param string|null $keyword
     */
    public function __construct(array $categoryDescription = [],
                                array $categoryStore = [],
                                array $categoryFilter = [],
                                ?int $sortOrder = 0,
                                ?int $parentId = null,
                                ?int $column = 0,
                                ?int $top = 0,
                                ?string $image = null,
                                ?string $status = null,
                                ?string $keyword = null)
    {
        $this->categoryDescription = $categoryDescription;
        $this->categoryStore = $categoryStore;
        $this->categoryFilter = $categoryFilter;
        $this->image = $image;
        $this->sortOrder = $sortOrder;
        $this->parentId = $parentId;
        $this->status = $status;
        $this->column = $column;
        $this->top = $top;
        $this->keyword = $keyword;
    }

    /**
     * @return array
     */
    public function getCategoryDescription(): array
    {
        return $this->categoryDescription;
    }

    /**
     * @param array $categoryDescription
     * @return Category
     */
    public function setCategoryDescription(array $categoryDescription): Category
    {
        $this->categoryDescription = $categoryDescription;
        return $this;
    }

    /**
     * @return array
     */
    public function getCategoryStore(): array
    {
        return $this->categoryStore;
    }

    /**
     * @param array $categoryStore
     * @return Category
     */
    public function setCategoryStore(array $categoryStore): Category
    {
        $this->categoryStore = $categoryStore;
        return $this;
    }

    /**
     * @return array
     */
    public function getCategoryFilter(): array
    {
        return $this->categoryFilter;
    }

    /**
     * @param array $categoryFilter
     * @return Category
     */
    public function setCategoryFilter(array $categoryFilter): Category
    {
        $this->categoryFilter = $categoryFilter;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImage(): ?string
    {
        return $this->image;
    }

    /**
     * @param string|null $image
     * @return Category
     */
    public function setImage(?string $image): Category
    {
        $this->image = $image;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getSortOrder(): ?int
    {
        return $this->sortOrder;
    }

    /**
     * @param int|null $sortOrder
     * @return Category
     */
    public function setSortOrder(?int $sortOrder): Category
    {
        $this->sortOrder = $sortOrder;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getParentId(): ?int
    {
        return $this->parentId;
    }

    /**
     * @param int|null $parentId
     * @return Category
     */
    public function setParentId(?int $parentId): Category
    {
        $this->parentId = $parentId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @param string|null $status
     * @return Category
     */
    public function setStatus(?string $status): Category
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getColumn(): ?int
    {
        return $this->column;
    }

    /**
     * @param int|null $column
     * @return Category
     */
    public function setColumn(?int $column): Category
    {
        $this->column = $column;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getTop(): ?int
    {
        return $this->top;
    }

    /**
     * @param int|null $top
     * @return Category
     */
    public function setTop(?int $top): Category
    {
        $this->top = $top;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getKeyword(): ?string
    {
        return $this->keyword;
    }

    /**
     * @param string|null $keyword
     * @return Category
     */
    public function setKeyword(?string $keyword): Category
    {
        $this->keyword = $keyword;
        return $this;
    }

}


