<?php


namespace RTMTrade\OpenCart\AdminApi\Mapping;


use AutoMapperPlus\Configuration\AutoMapperConfigInterface;
use AutoMapperPlus\MappingOperation\Operation;
use RTMTrade\OpenCart\AdminApi\Model\Address;
use RTMTrade\OpenCart\AdminApi\Model\Customer;
use RTMTrade\OpenCart\AdminApi\Model\CustomField;
use stdClass;

class CustomerMapper implements ObjectMapperInterface
{

    public static function registerMappings(AutoMapperConfigInterface $config)
    {
        self::registerCustomField($config);
        self::registerCustomer($config);
    }

    protected static function registerCustomField(AutoMapperConfigInterface $config): void
    {
        $config->registerMapping(stdClass::class, CustomField::class)
            ->forMember('id',
                Operation::fromProperty('custom_field_id'));
    }

    protected static function registerCustomer(AutoMapperConfigInterface $config): void
    {
        $config->registerMapping(stdClass::class, Customer::class)
            // map customer_id to $id
            ->forMember('id',
                Operation::fromProperty('customer_id'))
            // parse date_added
            ->forMember('dateAdded',
                Operation::mapFrom(ObjectMapper::dateMapper('d/m/Y', 'date_added')))
            // map custom fields collection
            ->forMember('customFields',
                Operation::mapCollectionTo(CustomField::class))
            // map addresses collection
            ->forMember('addresses',
                Operation::mapCollectionTo(Address::class));
    }
}