<?php

namespace RTMTrade\OpenCart\AdminApi\Api;

use AutoMapperPlus\AutoMapperInterface;
use AutoMapperPlus\Exception\UnregisteredMappingException;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\GuzzleException;
use Psr\Log\LoggerInterface;
use RTMTrade\OpenCart\AdminApi\ApiException;
use RTMTrade\OpenCart\AdminApi\Configuration;
use RTMTrade\OpenCart\AdminApi\HeaderSelector;
use RTMTrade\OpenCart\AdminApi\Model\ApiResponse;

class ProductLatestApi extends AbstractApi
{
    public function __construct(ClientInterface $client, Configuration $config, HeaderSelector $headerSelector, AutoMapperInterface $mapper, LoggerInterface $logger = null)
    {
        parent::__construct($client, $config, $headerSelector, $mapper, $logger);
        $this->resourceClass = 'int';
        $this->resourceName = 'latest';

        $this->allowedOperations = [
            'list'
        ];
    }

    /**
     * @param int $limit
     * @return int[]
     * @throws ApiException
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function listLimit(int $limit): array
    {
        /** @var ApiResponse $response */
        [$response] = $this->listLimitWithHttpInfo($limit);

        return $this->mapper->mapMultiple($response->getData(), $this->resourceClass);
    }

    /**
     * @param int $limit
     * @return int[]
     * @throws ApiException
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listLimitWithHttpInfo(int $limit): array
    {
        $request = $this->createListBySubresourceRequest('limit', $limit);

        return $this->sendRequest($request);
    }


    /**
     * @param int $limit
     * @return int[]
     * @throws ApiException
     * @throws GuzzleException
     * @throws UnregisteredMappingException
     */
    public function listDetailsLimit(int $limit): array
    {
        $name = $this->resourceName;
        $this->resourceName = 'latestwithdetails';

        $ids = $this->listLimit($limit);

        $this->resourceName = $name;

        return $ids;
    }

    /**
     * @param int $limit
     * @return int[]
     * @throws ApiException
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listDetailsLimitWithHttpInfo(int $limit): array
    {
        $name = $this->resourceName;
        $this->resourceName = 'latestwithdetails';

        $apiResponse = $this->listLimitWithHttpInfo($limit);

        $this->resourceName = $name;

        return $apiResponse;
    }


    /**
     * @return int[]
     * @throws ApiException
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listDetails(): array
    {
        $name = $this->resourceName;
        $this->resourceName = 'latestwithdetails';

        $ids = $this->list();

        $this->resourceName = $name;

        return $ids;
    }

    /**
     * @return int[]
     * @throws ApiException
     * @throws UnregisteredMappingException
     * @throws GuzzleException
     */
    public function listDetailsWithHttpInfo(): array
    {
        $name = $this->resourceName;
        $this->resourceName = 'latestwithdetails';

        $apiResponse = $this->listWithHttpInfo();

        $this->resourceName = $name;

        return $apiResponse;
    }

}
