<?php

namespace RTMTrade\OpenCart\AdminApi\Api;

use AutoMapperPlus\AutoMapperInterface;
use GuzzleHttp\ClientInterface;
use Psr\Log\LoggerInterface;
use RTMTrade\OpenCart\AdminApi\Configuration;
use RTMTrade\OpenCart\AdminApi\HeaderSelector;
use RTMTrade\OpenCart\AdminApi\Model\AttributeGroup;

/**
 * ProductAttributeGroupsApi Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductAttributeGroupsApi extends AbstractApi
{

    public function __construct(ClientInterface $client, Configuration $config, HeaderSelector $headerSelector, AutoMapperInterface $mapper, LoggerInterface $logger = null)
    {
        parent::__construct($client, $config, $headerSelector, $mapper, $logger);
        $this->resourceClass = AttributeGroup::class;
        $this->resourceName = 'attributegroups';

        $this->allowedOperations = [
            'add',
            'update',
            'delete',
            'bulkDelete',
            'pagination'
        ];
    }

}
