<?php
/**
 * OrderProduct
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

use \ArrayAccess;
use \RTMTrade\OpenCart\AdminApi\ObjectSerializer;

/**
 * OrderProduct Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class OrderProduct implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderProduct';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'productId' => 'int',
        'quantity' => 'int',
        'option' => '\RTMTrade\OpenCart\AdminApi\Model\OrderProductOption',
        'orderProductId' => 'int',
        "name" => 'string',
        "model" => 'string',
        "sku" => 'string',
        "taxClassId" => 'int',
        "currencyCode" => 'string',
        "currencyValue" => 'string',
        "priceFormatted" => 'string',
        "price" => 'double',
        "priceExcludeTax" => 'double',
        "tax" => 'double',
        "totalFormatted" => 'string',
        "total" => 'double',
        "totalExcludeTax" => 'double',
        "totalTax" => 'double'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'productId' => 'int32',
        'quantity' => 'int32',
        'option' => null,
        'orderProductId' => 'int32',
        "name" => null,
        "model" => null,
        "sku" => null,
        "taxClassId" => 'int32',
        "currencyCode" => null,
        "currencyValue" => null,
        "priceFormatted" => null,
        "price" => 'double',
        "priceExcludeTax" => 'double',
        "tax" => 'double',
        "totalFormatted" => null,
        "total" => 'double',
        "totalExcludeTax" => 'double',
        "totalTax" => 'double'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'productId' => 'product_id',
        'orderProductId' => 'order_product_id',
        'quantity' => 'quantity',
        'option' => 'option',
        "name" => "name",
        "model" => "model",
        "sku" => "sku",
        "taxClassId" => "tax_class_id",
        "currencyCode" => "currency_code",
        "currencyValue" => "currency_value",
        "priceFormatted" => "price_formated",
        "price" => "price",
        "priceExcludeTax" => "price_exclude_tax",
        "tax" => "tax",
        "totalFormatted" => "total_formated",
        "total" => "total",
        "totalExcludeTax" => "total_exclude_tax",
        "totalTax" => "total_tax"
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'productId' => 'setProductId',
        'quantity' => 'setQuantity',
        'option' => 'setOption',
        'orderProductId' => 'setOrderProductId',
        "name" => 'setName',
        "model" => 'setModel',
        "sku" => 'setSku',
        "taxClassId" => 'setTaxClassId',
        "currencyCode" => 'setCurrencyCode',
        "currencyValue" => 'setCurrencyValue',
        "priceFormatted" => 'setPriceFormatted',
        "price" => 'setPrice',
        "priceExcludeTax" => 'setPriceExcludeTax',
        "tax" => 'setTax',
        "totalFormatted" => 'setTotalFormatted',
        "total" => 'setTotal',
        "totalExcludeTax" => 'setTotalExcludeTax',
        "totalTax" => 'setTotalTax'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'productId' => 'getProductId',
        'quantity' => 'getQuantity',
        'option' => 'getOption',
        'orderProductId' => 'getOrderProductId',
        "name" => 'getName',
        "model" => 'getModel',
        "sku" => 'getSku',
        "taxClassId" => 'getTaxClassId',
        "currencyCode" => 'getCurrencyCode',
        "currencyValue" => 'getCurrencyValue',
        "priceFormatted" => 'getPriceFormatted',
        "price" => 'getPrice',
        "priceExcludeTax" => 'getPriceExcludeTax',
        "tax" => 'getTax',
        "totalFormatted" => 'getTotalFormatted',
        "total" => 'getTotal',
        "totalExcludeTax" => 'getTotalExcludeTax',
        "totalTax" => 'getTotalTax'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['productId'] = isset($data['productId']) ? $data['productId'] : null;
        $this->container['quantity'] = isset($data['quantity']) ? $data['quantity'] : null;
        $this->container['option'] = isset($data['option']) ? $data['option'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['productId'] === null) {
            $invalidProperties[] = "'productId' can't be null";
        }
        if ($this->container['quantity'] === null) {
            $invalidProperties[] = "'quantity' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets productId
     *
     * @return int
     */
    public function getProductId()
    {
        return $this->container['productId'];
    }

    /**
     * Sets productId
     *
     * @param int $productId Product Id
     *
     * @return $this
     */
    public function setProductId($productId)
    {
        $this->container['productId'] = $productId;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int $quantity Quantity
     *
     * @return $this
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets option
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\OrderProductOption|null
     */
    public function getOption()
    {
        return $this->container['option'];
    }

    /**
     * Sets option
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\OrderProductOption|null $option option
     *
     * @return $this
     */
    public function setOption($option)
    {
        $this->container['option'] = $option;

        return $this;
    }

    public function getOrderProductId() {
        return $this->container['orderProductId'];
    }

    public function setOrderProductId($value) {
        $this->container['orderProductId'] = $value;
        return $this;
    }

    public function getName() {
        return $this->container['name'];
    }

    public function setName($value) {
        $this->container['name'] = $value;
        return $this;
    }

    public function getModel() {
        return $this->container['model'];
    }

    public function setModel($value) {
        $this->container['model'] = $value;
        return $this;
    }

    public function getSku() {
        return $this->container['sku'];
    }

    public function setSku($value) {
        $this->container['sku'] = $value;
        return $this;
    }

    public function getTaxClassId() {
        return $this->container['taxClassId'];
    }

    public function setTaxClassId($value) {
        $this->container['taxClassId'] = $value;
        return $this;
    }

    public function getCurrencyCode() {
        return $this->container['currencyCode'];
    }

    public function setCurrencyCode($value) {
        $this->container['currencyCode'] = $value;
        return $this;
    }

    public function getCurrencyValue() {
        return $this->container['currencyValue'];
    }

    public function setCurrencyValue($value) {
        $this->container['currencyValue'] = $value;
        return $this;
    }

    public function getPriceFormatted() {
        return $this->container['priceFormatted'];
    }

    public function setPriceFormatted($value) {
        $this->container['priceFormatted'] = $value;
        return $this;
    }

    public function getPrice() {
        return $this->container['price'];
    }

    public function setPrice($value) {
        $this->container['price'] = $value;
        return $this;
    }

    public function getPriceExcludeTax() {
        return $this->container['priceExcludeTax'];
    }

    public function setPriceExcludeTax($value) {
        $this->container['priceExcludeTax'] = $value;
        return $this;
    }

    public function getTax() {
        return $this->container['tax'];
    }

    public function setTax($value) {
        $this->container['tax'] = $value;
        return $this;
    }

    public function getTotalFormatted() {
        return $this->container['totalFormatted'];
    }

    public function setTotalFormatted($value) {
        $this->container['totalFormatted'] = $value;
        return $this;
    }

    public function getTotal() {
        return $this->container['total'];
    }

    public function setTotal($value) {
        $this->container['total'] = $value;
        return $this;
    }

    public function getTotalExcludeTax() {
        return $this->container['totalExcludeTax'];
    }

    public function setTotalExcludeTax($value) {
        $this->container['totalExcludeTax'] = $value;
        return $this;
    }

    public function getTotalTax() {
        return $this->container['totalTax'];
    }

    public function setTotalTax($value) {
        $this->container['totalTax'] = $value;
        return $this;
    }


    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


