<?php
/**
 * Category
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

use \ArrayAccess;
use \RTMTrade\OpenCart\AdminApi\ObjectSerializer;

/**
 * Category Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Category implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Category';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'categoryDescription' => '\RTMTrade\OpenCart\AdminApi\Model\CategoryDescription[]',
        'image' => 'string',
        'sortOrder' => 'int',
        'categoryStore' => 'int[]',
        'parentId' => 'int',
        'status' => 'string',
        'categoryFilter' => 'int[]',
        'column' => 'int',
        'top' => 'int',
        'keyword' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'categoryDescription' => null,
        'image' => null,
        'sortOrder' => 'int32',
        'categoryStore' => 'int32',
        'parentId' => 'int32',
        'status' => null,
        'categoryFilter' => 'int32',
        'column' => 'int32',
        'top' => 'int32',
        'keyword' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'categoryDescription' => 'category_description',
        'image' => 'image',
        'sortOrder' => 'sort_order',
        'categoryStore' => 'category_store',
        'parentId' => 'parent_id',
        'status' => 'status',
        'categoryFilter' => 'category_filter',
        'column' => 'column',
        'top' => 'top',
        'keyword' => 'keyword'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'categoryDescription' => 'setCategoryDescription',
        'image' => 'setImage',
        'sortOrder' => 'setSortOrder',
        'categoryStore' => 'setCategoryStore',
        'parentId' => 'setParentId',
        'status' => 'setStatus',
        'categoryFilter' => 'setCategoryFilter',
        'column' => 'setColumn',
        'top' => 'setTop',
        'keyword' => 'setKeyword'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'categoryDescription' => 'getCategoryDescription',
        'image' => 'getImage',
        'sortOrder' => 'getSortOrder',
        'categoryStore' => 'getCategoryStore',
        'parentId' => 'getParentId',
        'status' => 'getStatus',
        'categoryFilter' => 'getCategoryFilter',
        'column' => 'getColumn',
        'top' => 'getTop',
        'keyword' => 'getKeyword'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['categoryDescription'] = isset($data['categoryDescription']) ? $data['categoryDescription'] : null;
        $this->container['image'] = isset($data['image']) ? $data['image'] : null;
        $this->container['sortOrder'] = isset($data['sortOrder']) ? $data['sortOrder'] : 0;
        $this->container['categoryStore'] = isset($data['categoryStore']) ? $data['categoryStore'] : null;
        $this->container['parentId'] = isset($data['parentId']) ? $data['parentId'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : '1';
        $this->container['categoryFilter'] = isset($data['categoryFilter']) ? $data['categoryFilter'] : null;
        $this->container['column'] = isset($data['column']) ? $data['column'] : 1;
        $this->container['top'] = isset($data['top']) ? $data['top'] : null;
        $this->container['keyword'] = isset($data['keyword']) ? $data['keyword'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['categoryDescription'] === null) {
            $invalidProperties[] = "'categoryDescription' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets categoryDescription
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\CategoryDescription[]
     */
    public function getCategoryDescription()
    {
        return $this->container['categoryDescription'];
    }

    /**
     * Sets categoryDescription
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\CategoryDescription[] $categoryDescription 
     *
     * @return $this
     */
    public function setCategoryDescription($categoryDescription)
    {
        $this->container['categoryDescription'] = $categoryDescription;

        return $this;
    }

    /**
     * Gets image
     *
     * @return string|null
     */
    public function getImage()
    {
        return $this->container['image'];
    }

    /**
     * Sets image
     *
     * @param string|null $image Image path
     *
     * @return $this
     */
    public function setImage($image)
    {
        $this->container['image'] = $image;

        return $this;
    }

    /**
     * Gets sortOrder
     *
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->container['sortOrder'];
    }

    /**
     * Sets sortOrder
     *
     * @param int|null $sortOrder Sort order of category
     *
     * @return $this
     */
    public function setSortOrder($sortOrder)
    {
        $this->container['sortOrder'] = $sortOrder;

        return $this;
    }

    /**
     * Gets categoryStore
     *
     * @return int[]|null
     */
    public function getCategoryStore()
    {
        return $this->container['categoryStore'];
    }

    /**
     * Sets categoryStore
     *
     * @param int[]|null $categoryStore List of stores
     *
     * @return $this
     */
    public function setCategoryStore($categoryStore)
    {
        $this->container['categoryStore'] = $categoryStore;

        return $this;
    }

    /**
     * Gets parentId
     *
     * @return int|null
     */
    public function getParentId()
    {
        return $this->container['parentId'];
    }

    /**
     * Sets parentId
     *
     * @param int|null $parentId Category parent id
     *
     * @return $this
     */
    public function setParentId($parentId)
    {
        $this->container['parentId'] = $parentId;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Category status. (Acceptable values are: \"1-Enabled\", \"0-Disabled\")
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets categoryFilter
     *
     * @return int[]|null
     */
    public function getCategoryFilter()
    {
        return $this->container['categoryFilter'];
    }

    /**
     * Sets categoryFilter
     *
     * @param int[]|null $categoryFilter List of category filters
     *
     * @return $this
     */
    public function setCategoryFilter($categoryFilter)
    {
        $this->container['categoryFilter'] = $categoryFilter;

        return $this;
    }

    /**
     * Gets column
     *
     * @return int|null
     */
    public function getColumn()
    {
        return $this->container['column'];
    }

    /**
     * Sets column
     *
     * @param int|null $column Number of columns to use for the bottom 3 categories. Only works for the top parent categories.
     *
     * @return $this
     */
    public function setColumn($column)
    {
        $this->container['column'] = $column;

        return $this;
    }

    /**
     * Gets top
     *
     * @return int|null
     */
    public function getTop()
    {
        return $this->container['top'];
    }

    /**
     * Sets top
     *
     * @param int|null $top Display in the top menu bar. Only works for the top parent categories.
     *
     * @return $this
     */
    public function setTop($top)
    {
        $this->container['top'] = $top;

        return $this;
    }

    /**
     * Gets keyword
     *
     * @return string|null
     */
    public function getKeyword()
    {
        return $this->container['keyword'];
    }

    /**
     * Sets keyword
     *
     * @param string|null $keyword SEO URL
     *
     * @return $this
     */
    public function setKeyword($keyword)
    {
        $this->container['keyword'] = $keyword;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


