# RTMTrade\OpenCart\AdminApi\VoucherApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**voucherAdd**](VoucherApi.md#voucherAdd) | **POST** /vouchers | Add new voucher to store
[**voucherDelete**](VoucherApi.md#voucherDelete) | **DELETE** /vouchers/{id} | Delete voucher by ID
[**voucherDeleteMultiple**](VoucherApi.md#voucherDeleteMultiple) | **DELETE** /vouchers | Delete vouchers
[**voucherList**](VoucherApi.md#voucherList) | **GET** /vouchers/limit/{limit}/page/{page} | Get list of vouchers
[**voucherUpdate**](VoucherApi.md#voucherUpdate) | **PUT** /vouchers/{id} | Update voucher by ID
[**voucherthemesList**](VoucherApi.md#voucherthemesList) | **GET** /voucherthemes | Get list of voucher themes



## voucherAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse voucherAdd($voucherObject)

Add new voucher to store

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/vouchers</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/voucher_admin/vouchers</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\VoucherApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$voucherObject = new \RTMTrade\OpenCart\AdminApi\Model\VoucherObject(); // \RTMTrade\OpenCart\AdminApi\Model\VoucherObject | voucher object

try {
    $result = $apiInstance->voucherAdd($voucherObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoucherApi->voucherAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **voucherObject** | [**\RTMTrade\OpenCart\AdminApi\Model\VoucherObject**](../Model/VoucherObject.md)| voucher object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## voucherDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse voucherDelete($id)

Delete voucher by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/vouchers/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/voucher_admin/vouchers&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\VoucherApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | voucher Id

try {
    $result = $apiInstance->voucherDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoucherApi->voucherDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| voucher Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## voucherDeleteMultiple

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse voucherDeleteMultiple($voucherIds)

Delete vouchers

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/vouchers</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/voucher_admin/vouchers</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\VoucherApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$voucherIds = new \RTMTrade\OpenCart\AdminApi\Model\DeleteVoucher(); // \RTMTrade\OpenCart\AdminApi\Model\DeleteVoucher | voucher ids

try {
    $result = $apiInstance->voucherDeleteMultiple($voucherIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoucherApi->voucherDeleteMultiple: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **voucherIds** | [**\RTMTrade\OpenCart\AdminApi\Model\DeleteVoucher**](../Model/DeleteVoucher.md)| voucher ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## voucherList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse voucherList($limit, $page)

Get list of vouchers

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/vouchers/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/voucher_admin/vouchers&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\VoucherApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->voucherList($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoucherApi->voucherList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## voucherUpdate

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse voucherUpdate($id, $voucherObject)

Update voucher by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/vouchers/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/voucher_admin/vouchers&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\VoucherApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | voucher Id
$voucherObject = new \RTMTrade\OpenCart\AdminApi\Model\VoucherEditObject(); // \RTMTrade\OpenCart\AdminApi\Model\VoucherEditObject | voucher object

try {
    $result = $apiInstance->voucherUpdate($id, $voucherObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoucherApi->voucherUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| voucher Id |
 **voucherObject** | [**\RTMTrade\OpenCart\AdminApi\Model\VoucherEditObject**](../Model/VoucherEditObject.md)| voucher object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## voucherthemesList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse voucherthemesList()

Get list of voucher themes

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/voucherthemes</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/voucher_admin/voucherthemes</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\VoucherApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->voucherthemesList();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling VoucherApi->voucherthemesList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

