# RTMTrade\OpenCart\AdminApi\SystemDataApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**checksumList**](SystemDataApi.md#checksumList) | **GET** /checksums | Get checksums of product specific tables
[**countriesDetails**](SystemDataApi.md#countriesDetails) | **GET** /countries/{id} | Get zones
[**countriesList**](SystemDataApi.md#countriesList) | **GET** /countries | Get list of countries
[**ordersUtcOffset**](SystemDataApi.md#ordersUtcOffset) | **GET** /utc_offset | Get UTC offset
[**productsProductclasses**](SystemDataApi.md#productsProductclasses) | **GET** /init | Get product classes and other select values
[**systemDataByType**](SystemDataApi.md#systemDataByType) | **GET** /init/{type} | Get system information



## checksumList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse checksumList()

Get checksums of product specific tables

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/checksums</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/helpers/getchecksum</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\SystemDataApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->checksumList();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SystemDataApi->checksumList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## countriesDetails

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse countriesDetails($id)

Get zones

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/countries/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/helpers/countries&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\SystemDataApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 96; // int | Country ID

try {
    $result = $apiInstance->countriesDetails($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SystemDataApi->countriesDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Country ID | [default to 96]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## countriesList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse countriesList()

Get list of countries

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/countries</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/helpers/countries</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\SystemDataApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->countriesList();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SystemDataApi->countriesList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersUtcOffset

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersUtcOffset()

Get UTC offset

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/utc_offset</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/helpers/utc_offset</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\SystemDataApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->ordersUtcOffset();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SystemDataApi->ordersUtcOffset: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsProductclasses

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsProductclasses()

Get product classes and other select values

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/init</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/helpers/productclasses</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\SystemDataApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->productsProductclasses();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SystemDataApi->productsProductclasses: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## systemDataByType

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse systemDataByType($type)

Get system information

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/init/{type}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/helpers/productclasses&type={type}</span><br><br>Types:<br><ul><li>order_statuses</li><li>stock_statuses</li><li>length_classes</li><li>weight_classes</li><li>tax_rates</li><li>tax_classes</li><li>tax_rules</li><li>stores</li><li>languages</li><li>currency</li><li>recurrings</li></ul>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\SystemDataApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$type = 'order_statuses'; // string | information type

try {
    $result = $apiInstance->systemDataByType($type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SystemDataApi->systemDataByType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**| information type | [default to &#39;order_statuses&#39;]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

