# RTMTrade\OpenCart\AdminApi\ProductOptionValueApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**optionValueAdd**](ProductOptionValueApi.md#optionValueAdd) | **POST** /optionvalue/{id} | Add option value to option
[**optionValueDelete**](ProductOptionValueApi.md#optionValueDelete) | **DELETE** /optionvalue | Delete option value
[**optionValueDeleteById**](ProductOptionValueApi.md#optionValueDeleteById) | **DELETE** /optionvalue/{id} | Delete option value by ID
[**optionValueEdit**](ProductOptionValueApi.md#optionValueEdit) | **PUT** /optionvalue/{id} | Edit option value



## optionValueAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse optionValueAdd($id, $optionValueObject)

Add option value to option

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/optionvalue/{option_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_value_admin/optionvalue&id={option_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionValueApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Option Id
$optionValueObject = new \RTMTrade\OpenCart\AdminApi\Model\OptionValue(); // \RTMTrade\OpenCart\AdminApi\Model\OptionValue | Option value object

try {
    $result = $apiInstance->optionValueAdd($id, $optionValueObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionValueApi->optionValueAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Option Id |
 **optionValueObject** | [**\RTMTrade\OpenCart\AdminApi\Model\OptionValue**](../Model/OptionValue.md)| Option value object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## optionValueDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse optionValueDelete($optionValueIds)

Delete option value

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/optionvalue</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_value_admin/optionvalue</span><br/>Sample request body:<br>{\"option_values\":[8,9]}

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionValueApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$optionValueIds = new \RTMTrade\OpenCart\AdminApi\Model\DeleteOptionValues(); // \RTMTrade\OpenCart\AdminApi\Model\DeleteOptionValues | Option value ids

try {
    $result = $apiInstance->optionValueDelete($optionValueIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionValueApi->optionValueDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **optionValueIds** | [**\RTMTrade\OpenCart\AdminApi\Model\DeleteOptionValues**](../Model/DeleteOptionValues.md)| Option value ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## optionValueDeleteById

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse optionValueDeleteById($id)

Delete option value by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/optionvalue/{option_value_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_value_admin/optionvalue&id={option_value_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionValueApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Option value Id

try {
    $result = $apiInstance->optionValueDeleteById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionValueApi->optionValueDeleteById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Option value Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## optionValueEdit

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse optionValueEdit($id, $optionValueObject)

Edit option value

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/optionvalue/{option_value_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_value_admin/optionvalue&id={option_value_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionValueApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 10; // int | Option value Id
$optionValueObject = new \RTMTrade\OpenCart\AdminApi\Model\OptionValue(); // \RTMTrade\OpenCart\AdminApi\Model\OptionValue | Option value object

try {
    $result = $apiInstance->optionValueEdit($id, $optionValueObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionValueApi->optionValueEdit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Option value Id | [default to 10]
 **optionValueObject** | [**\RTMTrade\OpenCart\AdminApi\Model\OptionValue**](../Model/OptionValue.md)| Option value object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

