# RTMTrade\OpenCart\AdminApi\ProductFeaturedApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**productsFeatured**](ProductFeaturedApi.md#productsFeatured) | **GET** /featured | Get list of featured products
[**productsFeatured1**](ProductFeaturedApi.md#productsFeatured1) | **GET** /featured/limit/{limit} | Get list of featured products per limit
[**productsSetFeatured**](ProductFeaturedApi.md#productsSetFeatured) | **POST** /featured | Set featured products
[**productsUpdateFeatured**](ProductFeaturedApi.md#productsUpdateFeatured) | **PUT** /featured/{id} | Update featured products



## productsFeatured

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsFeatured()

Get list of featured products

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/featured</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/featured</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductFeaturedApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->productsFeatured();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductFeaturedApi->productsFeatured: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsFeatured1

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsFeatured1($limit)

Get list of featured products per limit

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/featured/{limit}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/featured&limit={limit}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductFeaturedApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | limit

try {
    $result = $apiInstance->productsFeatured1($limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductFeaturedApi->productsFeatured1: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| limit | [default to 10]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsSetFeatured

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsSetFeatured($featuredProductsObject)

Set featured products

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/featured</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/featured</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductFeaturedApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$featuredProductsObject = new \RTMTrade\OpenCart\AdminApi\Model\FeaturedProduct(); // \RTMTrade\OpenCart\AdminApi\Model\FeaturedProduct | Featured product object

try {
    $result = $apiInstance->productsSetFeatured($featuredProductsObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductFeaturedApi->productsSetFeatured: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **featuredProductsObject** | [**\RTMTrade\OpenCart\AdminApi\Model\FeaturedProduct**](../Model/FeaturedProduct.md)| Featured product object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsUpdateFeatured

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsUpdateFeatured($id, $featuredProductsObject)

Update featured products

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/featured/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/featured&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductFeaturedApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Module Id
$featuredProductsObject = new \RTMTrade\OpenCart\AdminApi\Model\FeaturedProduct(); // \RTMTrade\OpenCart\AdminApi\Model\FeaturedProduct | Featured product object

try {
    $result = $apiInstance->productsUpdateFeatured($id, $featuredProductsObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductFeaturedApi->productsUpdateFeatured: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Module Id |
 **featuredProductsObject** | [**\RTMTrade\OpenCart\AdminApi\Model\FeaturedProduct**](../Model/FeaturedProduct.md)| Featured product object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

