# RTMTrade\OpenCart\AdminApi\CategoryApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**categoriesByLevel**](CategoryApi.md#categoriesByLevel) | **GET** /categories/level/{level} | Get list of categories by depth level
[**categoriesByParentId**](CategoryApi.md#categoriesByParentId) | **GET** /categories/parent/{parent} | Get list of categories by parent ID
[**categoriesByParentId1**](CategoryApi.md#categoriesByParentId1) | **GET** /categories/parent/{parent}/level/{level} | Get list of categories by parent ID and level
[**categoriesDelete**](CategoryApi.md#categoriesDelete) | **DELETE** /categories | Delete categories
[**categoriesDeleteById**](CategoryApi.md#categoriesDeleteById) | **DELETE** /categories/{id} | Delete category by ID
[**categoriesDetails**](CategoryApi.md#categoriesDetails) | **GET** /categories/{id} | Get category details by ID
[**categoriesList**](CategoryApi.md#categoriesList) | **GET** /categories | Get list of categories (default 1 level)
[**categoryAdd**](CategoryApi.md#categoryAdd) | **POST** /categories | Add new category to store
[**categoryEdit**](CategoryApi.md#categoryEdit) | **PUT** /categories/{id} | Edit category
[**categoryExtendedListPagination**](CategoryApi.md#categoryExtendedListPagination) | **GET** /categories/extended/limit/{limit}/page/{page} | Get list of categories (all in one request)
[**categoryUpdateImage**](CategoryApi.md#categoryUpdateImage) | **POST** /categories/{id}/images | Add image to category by category ID



## categoriesByLevel

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoriesByLevel($level)

Get list of categories by depth level

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories/level/{level}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/category&level={level}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$level = 2; // int | Level number

try {
    $result = $apiInstance->categoriesByLevel($level);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoriesByLevel: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **level** | **int**| Level number | [default to 2]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## categoriesByParentId

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoriesByParentId($parent)

Get list of categories by parent ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories/parent/{parent}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/category&parent={parent}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$parent = 18; // int | Parent Category ID

try {
    $result = $apiInstance->categoriesByParentId($parent);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoriesByParentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **parent** | **int**| Parent Category ID | [default to 18]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## categoriesByParentId1

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoriesByParentId1($level, $parent)

Get list of categories by parent ID and level

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories/parent/{parent}/level/{level}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/category&parent={parent}&level={level}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$level = 2; // int | Level
$parent = 20; // int | Parent Category ID

try {
    $result = $apiInstance->categoriesByParentId1($level, $parent);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoriesByParentId1: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **level** | **int**| Level | [default to 2]
 **parent** | **int**| Parent Category ID | [default to 20]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## categoriesDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoriesDelete($categoryIds)

Delete categories

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/category</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$categoryIds = new \RTMTrade\OpenCart\AdminApi\Model\DeleteCategories(); // \RTMTrade\OpenCart\AdminApi\Model\DeleteCategories | Category ids

try {
    $result = $apiInstance->categoriesDelete($categoryIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoriesDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **categoryIds** | [**\RTMTrade\OpenCart\AdminApi\Model\DeleteCategories**](../Model/DeleteCategories.md)| Category ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## categoriesDeleteById

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoriesDeleteById($id)

Delete category by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/category&id={category_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 20; // int | Category Id

try {
    $result = $apiInstance->categoriesDeleteById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoriesDeleteById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Category Id | [default to 20]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## categoriesDetails

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoriesDetails($id)

Get category details by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/category&id={category_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 20; // int | Category Id

try {
    $result = $apiInstance->categoriesDetails($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoriesDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Category Id | [default to 20]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## categoriesList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoriesList()

Get list of categories (default 1 level)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/category</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->categoriesList();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoriesList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## categoryAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoryAdd($categoryObject)

Add new category to store

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/category</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$categoryObject = new \RTMTrade\OpenCart\AdminApi\Model\Category(); // \RTMTrade\OpenCart\AdminApi\Model\Category | Category object

try {
    $result = $apiInstance->categoryAdd($categoryObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoryAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **categoryObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Category**](../Model/Category.md)| Category object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## categoryEdit

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoryEdit($id, $categoryObject)

Edit category

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories/{category_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/category&id={category_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Category id
$categoryObject = new \RTMTrade\OpenCart\AdminApi\Model\CategoryEditObject(); // \RTMTrade\OpenCart\AdminApi\Model\CategoryEditObject | Category object

try {
    $result = $apiInstance->categoryEdit($id, $categoryObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoryEdit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Category id |
 **categoryObject** | [**\RTMTrade\OpenCart\AdminApi\Model\CategoryEditObject**](../Model/CategoryEditObject.md)| Category object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## categoryExtendedListPagination

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoryExtendedListPagination($limit, $page)

Get list of categories (all in one request)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories/extended/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/category&extended=1&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->categoryExtendedListPagination($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoryExtendedListPagination: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## categoryUpdateImage

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse categoryUpdateImage($id, $file)

Add image to category by category ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/categories/{id}/images</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/category_admin/categoryimages&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Category Id
$file = "/path/to/file.txt"; // \SplFileObject | 

try {
    $result = $apiInstance->categoryUpdateImage($id, $file);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CategoryApi->categoryUpdateImage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Category Id |
 **file** | **\SplFileObject****\SplFileObject**|  |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

