<?php
/**
 * ProductOptionValue
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

use \ArrayAccess;
use \RTMTrade\OpenCart\AdminApi\ObjectSerializer;

/**
 * ProductOptionValue Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ProductOptionValue implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductOptionValue';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'price' => 'double',
        'pricePrefix' => 'string',
        'subtract' => 'int',
        'points' => 'int',
        'pointsPrefix' => 'string',
        'weight' => 'int',
        'weightPrefix' => 'string',
        'optionValueId' => 'int',
        'quantity' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'price' => 'double',
        'pricePrefix' => null,
        'subtract' => 'int32',
        'points' => 'int32',
        'pointsPrefix' => null,
        'weight' => 'int32',
        'weightPrefix' => null,
        'optionValueId' => 'int32',
        'quantity' => 'int32'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'price' => 'price',
        'pricePrefix' => 'price_prefix',
        'subtract' => 'subtract',
        'points' => 'points',
        'pointsPrefix' => 'points_prefix',
        'weight' => 'weight',
        'weightPrefix' => 'weight_prefix',
        'optionValueId' => 'option_value_id',
        'quantity' => 'quantity'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'price' => 'setPrice',
        'pricePrefix' => 'setPricePrefix',
        'subtract' => 'setSubtract',
        'points' => 'setPoints',
        'pointsPrefix' => 'setPointsPrefix',
        'weight' => 'setWeight',
        'weightPrefix' => 'setWeightPrefix',
        'optionValueId' => 'setOptionValueId',
        'quantity' => 'setQuantity'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'price' => 'getPrice',
        'pricePrefix' => 'getPricePrefix',
        'subtract' => 'getSubtract',
        'points' => 'getPoints',
        'pointsPrefix' => 'getPointsPrefix',
        'weight' => 'getWeight',
        'weightPrefix' => 'getWeightPrefix',
        'optionValueId' => 'getOptionValueId',
        'quantity' => 'getQuantity'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['price'] = isset($data['price']) ? $data['price'] : null;
        $this->container['pricePrefix'] = isset($data['pricePrefix']) ? $data['pricePrefix'] : null;
        $this->container['subtract'] = isset($data['subtract']) ? $data['subtract'] : 1;
        $this->container['points'] = isset($data['points']) ? $data['points'] : null;
        $this->container['pointsPrefix'] = isset($data['pointsPrefix']) ? $data['pointsPrefix'] : null;
        $this->container['weight'] = isset($data['weight']) ? $data['weight'] : null;
        $this->container['weightPrefix'] = isset($data['weightPrefix']) ? $data['weightPrefix'] : null;
        $this->container['optionValueId'] = isset($data['optionValueId']) ? $data['optionValueId'] : null;
        $this->container['quantity'] = isset($data['quantity']) ? $data['quantity'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['price'] === null) {
            $invalidProperties[] = "'price' can't be null";
        }
        if ($this->container['pricePrefix'] === null) {
            $invalidProperties[] = "'pricePrefix' can't be null";
        }
        if ($this->container['subtract'] === null) {
            $invalidProperties[] = "'subtract' can't be null";
        }
        if ($this->container['optionValueId'] === null) {
            $invalidProperties[] = "'optionValueId' can't be null";
        }
        if ($this->container['quantity'] === null) {
            $invalidProperties[] = "'quantity' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets price
     *
     * @return double
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param double $price Price
     *
     * @return $this
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets pricePrefix
     *
     * @return string
     */
    public function getPricePrefix()
    {
        return $this->container['pricePrefix'];
    }

    /**
     * Sets pricePrefix
     *
     * @param string $pricePrefix Price prefix
     *
     * @return $this
     */
    public function setPricePrefix($pricePrefix)
    {
        $this->container['pricePrefix'] = $pricePrefix;

        return $this;
    }

    /**
     * Gets subtract
     *
     * @return int
     */
    public function getSubtract()
    {
        return $this->container['subtract'];
    }

    /**
     * Sets subtract
     *
     * @param int $subtract Subtract
     *
     * @return $this
     */
    public function setSubtract($subtract)
    {
        $this->container['subtract'] = $subtract;

        return $this;
    }

    /**
     * Gets points
     *
     * @return int|null
     */
    public function getPoints()
    {
        return $this->container['points'];
    }

    /**
     * Sets points
     *
     * @param int|null $points Points
     *
     * @return $this
     */
    public function setPoints($points)
    {
        $this->container['points'] = $points;

        return $this;
    }

    /**
     * Gets pointsPrefix
     *
     * @return string|null
     */
    public function getPointsPrefix()
    {
        return $this->container['pointsPrefix'];
    }

    /**
     * Sets pointsPrefix
     *
     * @param string|null $pointsPrefix Points prefix
     *
     * @return $this
     */
    public function setPointsPrefix($pointsPrefix)
    {
        $this->container['pointsPrefix'] = $pointsPrefix;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return int|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param int|null $weight Weight
     *
     * @return $this
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets weightPrefix
     *
     * @return string|null
     */
    public function getWeightPrefix()
    {
        return $this->container['weightPrefix'];
    }

    /**
     * Sets weightPrefix
     *
     * @param string|null $weightPrefix Weight prefix
     *
     * @return $this
     */
    public function setWeightPrefix($weightPrefix)
    {
        $this->container['weightPrefix'] = $weightPrefix;

        return $this;
    }

    /**
     * Gets optionValueId
     *
     * @return int
     */
    public function getOptionValueId()
    {
        return $this->container['optionValueId'];
    }

    /**
     * Sets optionValueId
     *
     * @param int $optionValueId Option value id
     *
     * @return $this
     */
    public function setOptionValueId($optionValueId)
    {
        $this->container['optionValueId'] = $optionValueId;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int $quantity Quantity
     *
     * @return $this
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


