# RTMTrade\OpenCart\AdminApi\StoreApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**storeCopy**](StoreApi.md#storeCopy) | **POST** /stores/copy/{id} | Create a new store(copy existing store)
[**storeGet**](StoreApi.md#storeGet) | **GET** /stores/{id} | Get store
[**storeList**](StoreApi.md#storeList) | **GET** /stores/ | Get list of stores
[**storeStats**](StoreApi.md#storeStats) | **GET** /stores/stats | Stat of Opencart store
[**storeUpdate**](StoreApi.md#storeUpdate) | **PUT** /stores/{id} | Update store by ID



## storeCopy

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse storeCopy($id, $storeObject)

Create a new store(copy existing store)

<span class=\"bold\">Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/stores/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/store_admin/store&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\StoreApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 0; // int | Store Id (default store id: 0)
$storeObject = new \RTMTrade\OpenCart\AdminApi\Model\Store(); // \RTMTrade\OpenCart\AdminApi\Model\Store | Store object

try {
    $result = $apiInstance->storeCopy($id, $storeObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StoreApi->storeCopy: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Store Id (default store id: 0) | [default to 0]
 **storeObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Store**](../Model/Store.md)| Store object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## storeGet

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse storeGet($id)

Get store

<span class=\"bold\">Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/stores/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/store_admin/store&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\StoreApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Store Id (default store id: 0)

try {
    $result = $apiInstance->storeGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StoreApi->storeGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Store Id (default store id: 0) |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## storeList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse storeList()

Get list of stores

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/stores</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/store_admin/store</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\StoreApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->storeList();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StoreApi->storeList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## storeStats

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse storeStats()

Stat of Opencart store

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/stores/stats</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/store_admin/stats</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\StoreApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->storeStats();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StoreApi->storeStats: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## storeUpdate

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse storeUpdate($id, $storeObject)

Update store by ID

<span class=\"bold\">Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/stores/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/store_admin/store&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\StoreApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Store Id
$storeObject = new \RTMTrade\OpenCart\AdminApi\Model\Store(); // \RTMTrade\OpenCart\AdminApi\Model\Store | Store object

try {
    $result = $apiInstance->storeUpdate($id, $storeObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StoreApi->storeUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Store Id |
 **storeObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Store**](../Model/Store.md)| Store object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

