# RTMTrade\OpenCart\AdminApi\ProductOptionApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**optionDelete**](ProductOptionApi.md#optionDelete) | **DELETE** /product_options/{id} | Delete product option details by ID
[**optionDetails**](ProductOptionApi.md#optionDetails) | **GET** /product_options/{id} | Get product option details by ID
[**optionsAdd**](ProductOptionApi.md#optionsAdd) | **POST** /product_options | Add new option
[**optionsDeleteMultiple**](ProductOptionApi.md#optionsDeleteMultiple) | **DELETE** /product_options | Delete options
[**optionsList**](ProductOptionApi.md#optionsList) | **GET** /product_options/limit/{limit}/page/{page} | Get list of product options
[**optionsUpdateImage**](ProductOptionApi.md#optionsUpdateImage) | **PUT** /product_options/{id}/images | Update option value image path
[**productOptionsUpdateImage**](ProductOptionApi.md#productOptionsUpdateImage) | **POST** /product_options/{id}/images | Add image to product option



## optionDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse optionDelete($id)

Delete product option details by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/product_options/{option_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_admin/option&id={option_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Option Id

try {
    $result = $apiInstance->optionDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionApi->optionDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Option Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## optionDetails

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse optionDetails($id)

Get product option details by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/product_options/{option_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_admin/option&id={option_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 2; // int | Option Id

try {
    $result = $apiInstance->optionDetails($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionApi->optionDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Option Id | [default to 2]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## optionsAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse optionsAdd($optionObject)

Add new option

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/product_options</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_admin/option</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$optionObject = new \RTMTrade\OpenCart\AdminApi\Model\ProductOption(); // \RTMTrade\OpenCart\AdminApi\Model\ProductOption | Option object

try {
    $result = $apiInstance->optionsAdd($optionObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionApi->optionsAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **optionObject** | [**\RTMTrade\OpenCart\AdminApi\Model\ProductOption**](../Model/ProductOption.md)| Option object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## optionsDeleteMultiple

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse optionsDeleteMultiple($optionIds)

Delete options

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/product_options</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_admin/option</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$optionIds = new \RTMTrade\OpenCart\AdminApi\Model\DeleteOptions(); // \RTMTrade\OpenCart\AdminApi\Model\DeleteOptions | Option ids

try {
    $result = $apiInstance->optionsDeleteMultiple($optionIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionApi->optionsDeleteMultiple: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **optionIds** | [**\RTMTrade\OpenCart\AdminApi\Model\DeleteOptions**](../Model/DeleteOptions.md)| Option ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## optionsList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse optionsList($limit, $page)

Get list of product options

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/product_options/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_admin/option&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->optionsList($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionApi->optionsList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## optionsUpdateImage

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse optionsUpdateImage($id, $image)

Update option value image path

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/product_options/{id}/images</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_admin/optionimages&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Option value Id
$image = 'image_example'; // string | Image

try {
    $result = $apiInstance->optionsUpdateImage($id, $image);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionApi->optionsUpdateImage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Option value Id |
 **image** | **string**| Image | [optional]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productOptionsUpdateImage

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productOptionsUpdateImage($id, $file)

Add image to product option

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/product_options/{id}/images</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/option_admin/optionimages&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductOptionApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Option value Id
$file = "/path/to/file.txt"; // \SplFileObject | 

try {
    $result = $apiInstance->productOptionsUpdateImage($id, $file);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductOptionApi->productOptionsUpdateImage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Option value Id |
 **file** | **\SplFileObject****\SplFileObject**|  |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

