# RTMTrade\OpenCart\AdminApi\ProductLatestApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**productsLatestDetailsLimit**](ProductLatestApi.md#productsLatestDetailsLimit) | **GET** /latestwithdetails/limit/{limit} | Get list of latest products with product info
[**productsLatestLimit**](ProductLatestApi.md#productsLatestLimit) | **GET** /latest/limit/{limit} | Get list of latest product ids
[**productsLatestLimit1**](ProductLatestApi.md#productsLatestLimit1) | **GET** /latest | Get the latest product id
[**productsLatestwithdetails**](ProductLatestApi.md#productsLatestwithdetails) | **GET** /latestwithdetails | Get the latest product with product info



## productsLatestDetailsLimit

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsLatestDetailsLimit($limit)

Get list of latest products with product info

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/latestwithdetails/{limit}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/latestwithdetails&limit={limit}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductLatestApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit

try {
    $result = $apiInstance->productsLatestDetailsLimit($limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductLatestApi->productsLatestDetailsLimit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsLatestLimit

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsLatestLimit($limit)

Get list of latest product ids

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/latest/{limit}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/latest&limit={limit}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductLatestApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit

try {
    $result = $apiInstance->productsLatestLimit($limit);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductLatestApi->productsLatestLimit: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsLatestLimit1

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsLatestLimit1()

Get the latest product id

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/latest</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/latest</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductLatestApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->productsLatestLimit1();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductLatestApi->productsLatestLimit1: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## productsLatestwithdetails

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse productsLatestwithdetails()

Get the latest product with product info

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/latestwithdetails</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/product_admin/latestwithdetails</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\ProductLatestApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->productsLatestwithdetails();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductLatestApi->productsLatestwithdetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

