# RTMTrade\OpenCart\AdminApi\OrderCreateOrderApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**orderadminAddv2**](OrderCreateOrderApi.md#orderadminAddv2) | **POST** /orderadmin | Add new order to database



## orderadminAddv2

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse orderadminAddv2($orderObject)

Add new order to database

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orderadmin</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/order</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderCreateOrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$orderObject = new \RTMTrade\OpenCart\AdminApi\Model\Order(); // \RTMTrade\OpenCart\AdminApi\Model\Order | Order object

try {
    $result = $apiInstance->orderadminAddv2($orderObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderCreateOrderApi->orderadminAddv2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **orderObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Order**](../Model/Order.md)| Order object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

