# RTMTrade\OpenCart\AdminApi\CustomerApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**customerAdd**](CustomerApi.md#customerAdd) | **POST** /customers | Add new customer
[**customerDelete**](CustomerApi.md#customerDelete) | **DELETE** /customers | Delete customers
[**customerDeleteById**](CustomerApi.md#customerDeleteById) | **DELETE** /customers/{id} | Delete customer by ID
[**customerDetails**](CustomerApi.md#customerDetails) | **GET** /customers/{id} | Get customer details by ID
[**customerDetailsEmail**](CustomerApi.md#customerDetailsEmail) | **GET** /customers/email/{email} | Get customer details by email
[**customerListAddedBetween**](CustomerApi.md#customerListAddedBetween) | **GET** /customers/added_from/{added_from}/added_to/{added_to} | Get list of customers filtered by date parameter (between)
[**customerListAddedFrom**](CustomerApi.md#customerListAddedFrom) | **GET** /customers/added_from/{added_from} | Get list of customers filtered by date parameter (from)
[**customerListAddedOn**](CustomerApi.md#customerListAddedOn) | **GET** /customers/added_on/{added_on} | Get list of customers filtered by  date parameter (on)
[**customerModify**](CustomerApi.md#customerModify) | **PUT** /customers/{id} | Modify customer
[**customersList**](CustomerApi.md#customersList) | **GET** /customers/limit/{limit}/page/{page} | Get list of customers
[**rewardAdd**](CustomerApi.md#rewardAdd) | **POST** /reward/{id} | Add reward points to customer
[**transactionAdd**](CustomerApi.md#transactionAdd) | **POST** /transaction/{id} | Add transaction points to customer



## customerAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customerAdd($customerObject)

Add new customer

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customers</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/customers</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customerObject = new \RTMTrade\OpenCart\AdminApi\Model\Customer(); // \RTMTrade\OpenCart\AdminApi\Model\Customer | Customer object

try {
    $result = $apiInstance->customerAdd($customerObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->customerAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Customer**](../Model/Customer.md)| Customer object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customerDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customerDelete($customerIds)

Delete customers

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customers</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/customers</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customerIds = new \RTMTrade\OpenCart\AdminApi\Model\DeleteCustomers(); // \RTMTrade\OpenCart\AdminApi\Model\DeleteCustomers | Customer ids

try {
    $result = $apiInstance->customerDelete($customerIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->customerDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerIds** | [**\RTMTrade\OpenCart\AdminApi\Model\DeleteCustomers**](../Model/DeleteCustomers.md)| Customer ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customerDeleteById

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customerDeleteById($id)

Delete customer by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customers/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/customers&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Customer Id

try {
    $result = $apiInstance->customerDeleteById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->customerDeleteById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Customer Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customerDetails

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customerDetails($id)

Get customer details by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customers/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/customers&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 1; // int | Customer Id

try {
    $result = $apiInstance->customerDetails($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->customerDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Customer Id | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customerDetailsEmail

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customerDetailsEmail($email)

Get customer details by email

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customers/email/{email}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/getcustomerbyemail&email={email}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$email = 'nash1@vipmail..hu'; // string | Customer email

try {
    $result = $apiInstance->customerDetailsEmail($email);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->customerDetailsEmail: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **email** | **string**| Customer email | [default to &#39;nash1@vipmail..hu&#39;]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customerListAddedBetween

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customerListAddedBetween($addedFrom, $addedTo)

Get list of customers filtered by date parameter (between)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customers/added_from/{added_from}/added_to/{added_to}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/customers&filter_date_added_from={added_from}&filter_date_added_to={added_to}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$addedFrom = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | From date added
$addedTo = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | To date added

try {
    $result = $apiInstance->customerListAddedBetween($addedFrom, $addedTo);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->customerListAddedBetween: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addedFrom** | **\DateTime**| From date added |
 **addedTo** | **\DateTime**| To date added |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customerListAddedFrom

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customerListAddedFrom($addedFrom)

Get list of customers filtered by date parameter (from)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customers/added_from/{added_from}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/customers&filter_date_added_from={added_from}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$addedFrom = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | From date added

try {
    $result = $apiInstance->customerListAddedFrom($addedFrom);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->customerListAddedFrom: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addedFrom** | **\DateTime**| From date added |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customerListAddedOn

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customerListAddedOn($addedOn)

Get list of customers filtered by  date parameter (on)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customers/added_on/{added_on}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/customers&filter_date_added_on={added_on}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$addedOn = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Customer added on date

try {
    $result = $apiInstance->customerListAddedOn($addedOn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->customerListAddedOn: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addedOn** | **\DateTime**| Customer added on date |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customerModify

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customerModify($id, $customerObject)

Modify customer

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customers/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/customers&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 1; // int | Customer Id
$customerObject = new \RTMTrade\OpenCart\AdminApi\Model\CustomerEditObject(); // \RTMTrade\OpenCart\AdminApi\Model\CustomerEditObject | Customer object

try {
    $result = $apiInstance->customerModify($id, $customerObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->customerModify: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Customer Id | [default to 1]
 **customerObject** | [**\RTMTrade\OpenCart\AdminApi\Model\CustomerEditObject**](../Model/CustomerEditObject.md)| Customer object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customersList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customersList($limit, $page)

Get list of customers

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customers/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/customers&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->customersList($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->customersList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## rewardAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse rewardAdd($id, $rewardObject)

Add reward points to customer

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/reward/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/reward&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 1; // int | Customer Id
$rewardObject = new \RTMTrade\OpenCart\AdminApi\Model\Reward(); // \RTMTrade\OpenCart\AdminApi\Model\Reward | Reward object

try {
    $result = $apiInstance->rewardAdd($id, $rewardObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->rewardAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Customer Id | [default to 1]
 **rewardObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Reward**](../Model/Reward.md)| Reward object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## transactionAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse transactionAdd($id, $transactionObject)

Add transaction points to customer

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/transaction/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_admin/transactions&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 1; // int | Customer Id
$transactionObject = new \RTMTrade\OpenCart\AdminApi\Model\Transaction(); // \RTMTrade\OpenCart\AdminApi\Model\Transaction | Transaction object

try {
    $result = $apiInstance->transactionAdd($id, $transactionObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerApi->transactionAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Customer Id | [default to 1]
 **transactionObject** | [**\RTMTrade\OpenCart\AdminApi\Model\Transaction**](../Model/Transaction.md)| Transaction object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

