<?php


namespace RTMTrade\OpenCart\AdminApi;


use DateTime;

class Token
{
    const DISCRIMINATOR = null;


    /**
     * @var string
     */
    private $accessToken;
    /**
     * @var string
     */
    private $tokenType;
    /**
     * @var integer
     */
    private $expires;
    /**
     * @var DateTime
     */
    private $since;


    /**
     * @return mixed
     */
    public function getAccessToken()
    {
        return $this->accessToken;
    }

    /**
     * @return mixed
     */
    public function getExpiresIn()
    {
        return $this->expires;
    }

    /**
     * @return mixed
     */
    public function getSince()
    {
        return $this->since;
    }

    /**
     * @return mixed
     */
    public function getTokenType()
    {
        return $this->tokenType;
    }

    /**
     * @param mixed $accessToken
     * @return Token
     */
    public function setAccessToken($accessToken)
    {
        $this->accessToken = $accessToken;
        return $this;
    }

    /**
     * @param mixed $expires
     * @return Token
     */
    public function setExpiresIn($expires)
    {
        $this->expires = $expires;
        return $this;
    }

    /**
     * @param mixed $since
     * @return Token
     */
    public function setSince($since)
    {
        $this->since = $since;
        return $this;
    }

    /**
     * @param mixed $tokenType
     * @return Token
     */
    public function setTokenType($tokenType)
    {
        $this->tokenType = $tokenType;
        return $this;
    }

    public function isExpired()
    {
        return $this->since->getTimestamp() + $this->expires < (new DateTime())->getTimestamp();
    }
}