<?php
/**
 * VoucherEditObject
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

use \ArrayAccess;
use \RTMTrade\OpenCart\AdminApi\ObjectSerializer;

/**
 * VoucherEditObject Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class VoucherEditObject implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'VoucherEditObject';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'code' => 'string',
        'fromName' => 'string',
        'fromEmail' => 'string',
        'toName' => 'string',
        'toEmail' => 'string',
        'message' => 'string',
        'voucherThemeId' => 'int',
        'amount' => 'int',
        'status' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'code' => null,
        'fromName' => null,
        'fromEmail' => null,
        'toName' => null,
        'toEmail' => null,
        'message' => null,
        'voucherThemeId' => 'int32',
        'amount' => 'int32',
        'status' => 'int32'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'code' => 'code',
        'fromName' => 'from_name',
        'fromEmail' => 'from_email',
        'toName' => 'to_name',
        'toEmail' => 'to_email',
        'message' => 'message',
        'voucherThemeId' => 'voucher_theme_id',
        'amount' => 'amount',
        'status' => 'status'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'code' => 'setCode',
        'fromName' => 'setFromName',
        'fromEmail' => 'setFromEmail',
        'toName' => 'setToName',
        'toEmail' => 'setToEmail',
        'message' => 'setMessage',
        'voucherThemeId' => 'setVoucherThemeId',
        'amount' => 'setAmount',
        'status' => 'setStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'code' => 'getCode',
        'fromName' => 'getFromName',
        'fromEmail' => 'getFromEmail',
        'toName' => 'getToName',
        'toEmail' => 'getToEmail',
        'message' => 'getMessage',
        'voucherThemeId' => 'getVoucherThemeId',
        'amount' => 'getAmount',
        'status' => 'getStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['code'] = isset($data['code']) ? $data['code'] : null;
        $this->container['fromName'] = isset($data['fromName']) ? $data['fromName'] : null;
        $this->container['fromEmail'] = isset($data['fromEmail']) ? $data['fromEmail'] : null;
        $this->container['toName'] = isset($data['toName']) ? $data['toName'] : null;
        $this->container['toEmail'] = isset($data['toEmail']) ? $data['toEmail'] : null;
        $this->container['message'] = isset($data['message']) ? $data['message'] : null;
        $this->container['voucherThemeId'] = isset($data['voucherThemeId']) ? $data['voucherThemeId'] : null;
        $this->container['amount'] = isset($data['amount']) ? $data['amount'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code The code the customer enters to activate the voucher.
     *
     * @return $this
     */
    public function setCode($code)
    {
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets fromName
     *
     * @return string|null
     */
    public function getFromName()
    {
        return $this->container['fromName'];
    }

    /**
     * Sets fromName
     *
     * @param string|null $fromName From Name
     *
     * @return $this
     */
    public function setFromName($fromName)
    {
        $this->container['fromName'] = $fromName;

        return $this;
    }

    /**
     * Gets fromEmail
     *
     * @return string|null
     */
    public function getFromEmail()
    {
        return $this->container['fromEmail'];
    }

    /**
     * Sets fromEmail
     *
     * @param string|null $fromEmail From E-Mail
     *
     * @return $this
     */
    public function setFromEmail($fromEmail)
    {
        $this->container['fromEmail'] = $fromEmail;

        return $this;
    }

    /**
     * Gets toName
     *
     * @return string|null
     */
    public function getToName()
    {
        return $this->container['toName'];
    }

    /**
     * Sets toName
     *
     * @param string|null $toName To Name
     *
     * @return $this
     */
    public function setToName($toName)
    {
        $this->container['toName'] = $toName;

        return $this;
    }

    /**
     * Gets toEmail
     *
     * @return string|null
     */
    public function getToEmail()
    {
        return $this->container['toEmail'];
    }

    /**
     * Sets toEmail
     *
     * @param string|null $toEmail To E-Mail
     *
     * @return $this
     */
    public function setToEmail($toEmail)
    {
        $this->container['toEmail'] = $toEmail;

        return $this;
    }

    /**
     * Gets message
     *
     * @return string|null
     */
    public function getMessage()
    {
        return $this->container['message'];
    }

    /**
     * Sets message
     *
     * @param string|null $message Message
     *
     * @return $this
     */
    public function setMessage($message)
    {
        $this->container['message'] = $message;

        return $this;
    }

    /**
     * Gets voucherThemeId
     *
     * @return int|null
     */
    public function getVoucherThemeId()
    {
        return $this->container['voucherThemeId'];
    }

    /**
     * Sets voucherThemeId
     *
     * @param int|null $voucherThemeId Theme id
     *
     * @return $this
     */
    public function setVoucherThemeId($voucherThemeId)
    {
        $this->container['voucherThemeId'] = $voucherThemeId;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return int|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param int|null $amount Amount
     *
     * @return $this
     */
    public function setAmount($amount)
    {
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets status
     *
     * @return int|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param int|null $status Status (1-enabled, 0-disabled)
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


