<?php
/**
 * Order
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

use \ArrayAccess;
use \RTMTrade\OpenCart\AdminApi\ObjectSerializer;

/**
 * Order Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Order implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'storeId' => 'int',
        'comment' => 'string',
        'affiliateId' => 'string',
        'tracking' => 'string',
        'voucher' => 'string',
        'coupon' => 'string',
        'products' => '\RTMTrade\OpenCart\AdminApi\Model\OrderProduct[]',
        'shippingMethod' => '\RTMTrade\OpenCart\AdminApi\Model\ShippingMethod',
        'paymentMethod' => '\RTMTrade\OpenCart\AdminApi\Model\PaymentMethod',
        'paymentAddress' => '\RTMTrade\OpenCart\AdminApi\Model\PaymentAddress',
        'shippingAddress' => '\RTMTrade\OpenCart\AdminApi\Model\ShippingAddress',
        'customer' => '\RTMTrade\OpenCart\AdminApi\Model\OrderCustomer',
        'dateAdded' => 'string',
        'dateModified' => 'string',
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'id' => 'int32',
        'storeId' => 'int32',
        'comment' => null,
        'affiliateId' => null,
        'tracking' => null,
        'voucher' => null,
        'coupon' => null,
        'products' => null,
        'shippingMethod' => null,
        'paymentMethod' => null,
        'paymentAddress' => null,
        'shippingAddress' => null,
        'customer' => null,
        'dateAdded' => null,
        'dateModified' => null,
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'order_id',
        'storeId' => 'store_id',
        'comment' => 'comment',
        'affiliateId' => 'affiliate_id',
        'tracking' => 'tracking',
        'voucher' => 'voucher',
        'coupon' => 'coupon',
        'products' => 'products',
        'shippingMethod' => 'shipping_method',
        'paymentMethod' => 'payment_method',
        'paymentAddress' => 'payment_address',
        'shippingAddress' => 'shipping_address',
        'customer' => 'customer',
        'dateAdded' => 'date_added',
        'dateModified' => 'date_modified',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'storeId' => 'setStoreId',
        'comment' => 'setComment',
        'affiliateId' => 'setAffiliateId',
        'tracking' => 'setTracking',
        'voucher' => 'setVoucher',
        'coupon' => 'setCoupon',
        'products' => 'setProducts',
        'shippingMethod' => 'setShippingMethod',
        'paymentMethod' => 'setPaymentMethod',
        'paymentAddress' => 'setPaymentAddress',
        'shippingAddress' => 'setShippingAddress',
        'customer' => 'setCustomer',
        'dateAdded' => 'setDateAdded',
        'dateModified' => 'setDateModified'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'storeId' => 'getStoreId',
        'comment' => 'getComment',
        'affiliateId' => 'getAffiliateId',
        'tracking' => 'getTracking',
        'voucher' => 'getVoucher',
        'coupon' => 'getCoupon',
        'products' => 'getProducts',
        'shippingMethod' => 'getShippingMethod',
        'paymentMethod' => 'getPaymentMethod',
        'paymentAddress' => 'getPaymentAddress',
        'shippingAddress' => 'getShippingAddress',
        'customer' => 'getCustomer',
        'dateAdded' => 'getDateAdded',
        'dateModified' => 'getDateModified'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['storeId'] = isset($data['storeId']) ? $data['storeId'] : null;
        $this->container['comment'] = isset($data['comment']) ? $data['comment'] : null;
        $this->container['affiliateId'] = isset($data['affiliateId']) ? $data['affiliateId'] : null;
        $this->container['tracking'] = isset($data['tracking']) ? $data['tracking'] : null;
        $this->container['voucher'] = isset($data['voucher']) ? $data['voucher'] : null;
        $this->container['coupon'] = isset($data['coupon']) ? $data['coupon'] : null;
        $this->container['products'] = isset($data['products']) ? $data['products'] : null;
        $this->container['shippingMethod'] = isset($data['shippingMethod']) ? $data['shippingMethod'] : null;
        $this->container['paymentMethod'] = isset($data['paymentMethod']) ? $data['paymentMethod'] : null;
        $this->container['paymentAddress'] = isset($data['paymentAddress']) ? $data['paymentAddress'] : null;
        $this->container['shippingAddress'] = isset($data['shippingAddress']) ? $data['shippingAddress'] : null;
        $this->container['customer'] = isset($data['customer']) ? $data['customer'] : null;
        $this->container['dateAdded'] = isset($data['dateAdded']) ? $data['dateAdded'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['products'] === null) {
            $invalidProperties[] = "'products' can't be null";
        }
        if ($this->container['shippingMethod'] === null) {
            $invalidProperties[] = "'shippingMethod' can't be null";
        }
        if ($this->container['paymentMethod'] === null) {
            $invalidProperties[] = "'paymentMethod' can't be null";
        }
        if ($this->container['paymentAddress'] === null) {
            $invalidProperties[] = "'paymentAddress' can't be null";
        }
        if ($this->container['shippingAddress'] === null) {
            $invalidProperties[] = "'shippingAddress' can't be null";
        }
        if ($this->container['customer'] === null) {
            $invalidProperties[] = "'customer' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    public function getId()
    {
        return $this->container['id'];
    }

    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets storeId
     *
     * @return int|null
     */
    public function getStoreId()
    {
        return $this->container['storeId'];
    }

    /**
     * Sets storeId
     *
     * @param int|null $storeId Store Id
     *
     * @return $this
     */
    public function setStoreId($storeId)
    {
        $this->container['storeId'] = $storeId;

        return $this;
    }

    /**
     * Gets comment
     *
     * @return string|null
     */
    public function getComment()
    {
        return $this->container['comment'];
    }

    /**
     * Sets comment
     *
     * @param string|null $comment Comment
     *
     * @return $this
     */
    public function setComment($comment)
    {
        $this->container['comment'] = $comment;

        return $this;
    }

    /**
     * Gets affiliateId
     *
     * @return string|null
     */
    public function getAffiliateId()
    {
        return $this->container['affiliateId'];
    }

    /**
     * Sets affiliateId
     *
     * @param string|null $affiliateId Affiliate id
     *
     * @return $this
     */
    public function setAffiliateId($affiliateId)
    {
        $this->container['affiliateId'] = $affiliateId;

        return $this;
    }

    /**
     * Gets tracking
     *
     * @return string|null
     */
    public function getTracking()
    {
        return $this->container['tracking'];
    }

    /**
     * Sets tracking
     *
     * @param string|null $tracking tracking
     *
     * @return $this
     */
    public function setTracking($tracking)
    {
        $this->container['tracking'] = $tracking;

        return $this;
    }

    /**
     * Gets voucher
     *
     * @return string|null
     */
    public function getVoucher()
    {
        return $this->container['voucher'];
    }

    /**
     * Sets voucher
     *
     * @param string|null $voucher Voucher
     *
     * @return $this
     */
    public function setVoucher($voucher)
    {
        $this->container['voucher'] = $voucher;

        return $this;
    }

    /**
     * Gets coupon
     *
     * @return string|null
     */
    public function getCoupon()
    {
        return $this->container['coupon'];
    }

    /**
     * Sets coupon
     *
     * @param string|null $coupon Coupon
     *
     * @return $this
     */
    public function setCoupon($coupon)
    {
        $this->container['coupon'] = $coupon;

        return $this;
    }

    /**
     * Gets products
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\OrderProduct[]
     */
    public function getProducts()
    {
        return $this->container['products'];
    }

    /**
     * Sets products
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\OrderProduct[] $products Products
     *
     * @return $this
     */
    public function setProducts($products)
    {
        $this->container['products'] = $products;

        return $this;
    }

    /**
     * Gets shippingMethod
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\ShippingMethod
     */
    public function getShippingMethod()
    {
        return $this->container['shippingMethod'];
    }

    /**
     * Sets shippingMethod
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\ShippingMethod $shippingMethod shippingMethod
     *
     * @return $this
     */
    public function setShippingMethod($shippingMethod)
    {
        $this->container['shippingMethod'] = $shippingMethod;

        return $this;
    }

    /**
     * Gets paymentMethod
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\PaymentMethod
     */
    public function getPaymentMethod()
    {
        return $this->container['paymentMethod'];
    }

    /**
     * Sets paymentMethod
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\PaymentMethod $paymentMethod paymentMethod
     *
     * @return $this
     */
    public function setPaymentMethod($paymentMethod)
    {
        $this->container['paymentMethod'] = $paymentMethod;

        return $this;
    }

    /**
     * Gets paymentAddress
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\PaymentAddress
     */
    public function getPaymentAddress()
    {
        return $this->container['paymentAddress'];
    }

    /**
     * Sets paymentAddress
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\PaymentAddress $paymentAddress paymentAddress
     *
     * @return $this
     */
    public function setPaymentAddress($paymentAddress)
    {
        $this->container['paymentAddress'] = $paymentAddress;

        return $this;
    }

    /**
     * Gets shippingAddress
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\ShippingAddress
     */
    public function getShippingAddress()
    {
        return $this->container['shippingAddress'];
    }

    /**
     * Sets shippingAddress
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\ShippingAddress $shippingAddress shippingAddress
     *
     * @return $this
     */
    public function setShippingAddress($shippingAddress)
    {
        $this->container['shippingAddress'] = $shippingAddress;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\OrderCustomer
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\OrderCustomer $customer customer
     *
     * @return $this
     */
    public function setCustomer($customer)
    {
        $this->container['customer'] = $customer;

        return $this;
    }

    public function getDateAdded() {
        return $this->container['dateAdded'];
    }

    public function getDateModified() {
        return $this->container['dateModified'];
    }

    public function setDateAdded($value) {
        $this->container['dateAdded'] = $value;

        return $this;
    }
    public function setDateModified($value) {
        $this->container['dateModified'] = $value;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


