# RTMTrade\OpenCart\AdminApi\CustomerGroupApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**customergroupAdd**](CustomerGroupApi.md#customergroupAdd) | **POST** /customergroups | Add new customer group
[**customergroupDelete**](CustomerGroupApi.md#customergroupDelete) | **DELETE** /customergroups/{id} | Delete customer group
[**customergroupDeleteMultiple**](CustomerGroupApi.md#customergroupDeleteMultiple) | **DELETE** /customergroups | Delete customer groups
[**customergroupList**](CustomerGroupApi.md#customergroupList) | **GET** /customergroups/limit/{limit}/page/{page} | Get customer groups
[**customergroupModify**](CustomerGroupApi.md#customergroupModify) | **PUT** /customergroups/{id} | Modify customer group



## customergroupAdd

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customergroupAdd($customerGroupObject)

Add new customer group

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customergroups</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_group_admin/customergroup</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerGroupApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customerGroupObject = new \RTMTrade\OpenCart\AdminApi\Model\CustomerGroup(); // \RTMTrade\OpenCart\AdminApi\Model\CustomerGroup | Customer group object

try {
    $result = $apiInstance->customergroupAdd($customerGroupObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupApi->customergroupAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerGroupObject** | [**\RTMTrade\OpenCart\AdminApi\Model\CustomerGroup**](../Model/CustomerGroup.md)| Customer group object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customergroupDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customergroupDelete($id)

Delete customer group

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customergroups/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_group_admin/customergroup&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerGroupApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Customer group Id

try {
    $result = $apiInstance->customergroupDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupApi->customergroupDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Customer group Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customergroupDeleteMultiple

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customergroupDeleteMultiple($customerGroupsIds)

Delete customer groups

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customergroups</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_group_admin/customergroup</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerGroupApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customerGroupsIds = new \RTMTrade\OpenCart\AdminApi\Model\DeleteCustomerGroups(); // \RTMTrade\OpenCart\AdminApi\Model\DeleteCustomerGroups | Customer groups ids

try {
    $result = $apiInstance->customergroupDeleteMultiple($customerGroupsIds);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupApi->customergroupDeleteMultiple: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerGroupsIds** | [**\RTMTrade\OpenCart\AdminApi\Model\DeleteCustomerGroups**](../Model/DeleteCustomerGroups.md)| Customer groups ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customergroupList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customergroupList($limit, $page)

Get customer groups

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customergroups/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_group_admin/customergroup&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerGroupApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->customergroupList($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupApi->customergroupList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## customergroupModify

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse customergroupModify($id, $customerGroupObject)

Modify customer group

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/customergroups/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/customer_group_admin/customergroup&id={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\CustomerGroupApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Customer group Id
$customerGroupObject = new \RTMTrade\OpenCart\AdminApi\Model\CustomerGroupEditObject(); // \RTMTrade\OpenCart\AdminApi\Model\CustomerGroupEditObject | Customer group object

try {
    $result = $apiInstance->customergroupModify($id, $customerGroupObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupApi->customergroupModify: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Customer group Id |
 **customerGroupObject** | [**\RTMTrade\OpenCart\AdminApi\Model\CustomerGroupEditObject**](../Model/CustomerGroupEditObject.md)| Customer group object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

