<?php
/**
 * Store
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

use \ArrayAccess;
use \RTMTrade\OpenCart\AdminApi\ObjectSerializer;

/**
 * Store Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class Store implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Store';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'configTemplate' => 'string',
        'configMetaKeyword' => 'string',
        'configMetaDescription' => 'string',
        'configMetaTitle' => 'string',
        'configImage' => 'string',
        'configFax' => 'string',
        'configTelephone' => 'string',
        'configEmail' => 'string',
        'configAddress' => 'string',
        'configGeocode' => 'string',
        'configOwner' => 'string',
        'configName' => 'string',
        'configSsl' => 'string',
        'configUrl' => 'string',
        'configLogo' => 'string',
        'configLanguage' => 'string',
        'configCurrency' => 'string',
        'configProductLimit' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'configTemplate' => null,
        'configMetaKeyword' => null,
        'configMetaDescription' => null,
        'configMetaTitle' => null,
        'configImage' => null,
        'configFax' => null,
        'configTelephone' => null,
        'configEmail' => null,
        'configAddress' => null,
        'configGeocode' => null,
        'configOwner' => null,
        'configName' => null,
        'configSsl' => null,
        'configUrl' => null,
        'configLogo' => null,
        'configLanguage' => null,
        'configCurrency' => null,
        'configProductLimit' => 'int32'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'configTemplate' => 'config_template',
        'configMetaKeyword' => 'config_meta_keyword',
        'configMetaDescription' => 'config_meta_description',
        'configMetaTitle' => 'config_meta_title',
        'configImage' => 'config_image',
        'configFax' => 'config_fax',
        'configTelephone' => 'config_telephone',
        'configEmail' => 'config_email',
        'configAddress' => 'config_address',
        'configGeocode' => 'config_geocode',
        'configOwner' => 'config_owner',
        'configName' => 'config_name',
        'configSsl' => 'config_ssl',
        'configUrl' => 'config_url',
        'configLogo' => 'config_logo',
        'configLanguage' => 'config_language',
        'configCurrency' => 'config_currency',
        'configProductLimit' => 'config_product_limit'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'configTemplate' => 'setConfigTemplate',
        'configMetaKeyword' => 'setConfigMetaKeyword',
        'configMetaDescription' => 'setConfigMetaDescription',
        'configMetaTitle' => 'setConfigMetaTitle',
        'configImage' => 'setConfigImage',
        'configFax' => 'setConfigFax',
        'configTelephone' => 'setConfigTelephone',
        'configEmail' => 'setConfigEmail',
        'configAddress' => 'setConfigAddress',
        'configGeocode' => 'setConfigGeocode',
        'configOwner' => 'setConfigOwner',
        'configName' => 'setConfigName',
        'configSsl' => 'setConfigSsl',
        'configUrl' => 'setConfigUrl',
        'configLogo' => 'setConfigLogo',
        'configLanguage' => 'setConfigLanguage',
        'configCurrency' => 'setConfigCurrency',
        'configProductLimit' => 'setConfigProductLimit'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'configTemplate' => 'getConfigTemplate',
        'configMetaKeyword' => 'getConfigMetaKeyword',
        'configMetaDescription' => 'getConfigMetaDescription',
        'configMetaTitle' => 'getConfigMetaTitle',
        'configImage' => 'getConfigImage',
        'configFax' => 'getConfigFax',
        'configTelephone' => 'getConfigTelephone',
        'configEmail' => 'getConfigEmail',
        'configAddress' => 'getConfigAddress',
        'configGeocode' => 'getConfigGeocode',
        'configOwner' => 'getConfigOwner',
        'configName' => 'getConfigName',
        'configSsl' => 'getConfigSsl',
        'configUrl' => 'getConfigUrl',
        'configLogo' => 'getConfigLogo',
        'configLanguage' => 'getConfigLanguage',
        'configCurrency' => 'getConfigCurrency',
        'configProductLimit' => 'getConfigProductLimit'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['configTemplate'] = isset($data['configTemplate']) ? $data['configTemplate'] : null;
        $this->container['configMetaKeyword'] = isset($data['configMetaKeyword']) ? $data['configMetaKeyword'] : null;
        $this->container['configMetaDescription'] = isset($data['configMetaDescription']) ? $data['configMetaDescription'] : null;
        $this->container['configMetaTitle'] = isset($data['configMetaTitle']) ? $data['configMetaTitle'] : null;
        $this->container['configImage'] = isset($data['configImage']) ? $data['configImage'] : null;
        $this->container['configFax'] = isset($data['configFax']) ? $data['configFax'] : null;
        $this->container['configTelephone'] = isset($data['configTelephone']) ? $data['configTelephone'] : null;
        $this->container['configEmail'] = isset($data['configEmail']) ? $data['configEmail'] : null;
        $this->container['configAddress'] = isset($data['configAddress']) ? $data['configAddress'] : null;
        $this->container['configGeocode'] = isset($data['configGeocode']) ? $data['configGeocode'] : null;
        $this->container['configOwner'] = isset($data['configOwner']) ? $data['configOwner'] : null;
        $this->container['configName'] = isset($data['configName']) ? $data['configName'] : null;
        $this->container['configSsl'] = isset($data['configSsl']) ? $data['configSsl'] : null;
        $this->container['configUrl'] = isset($data['configUrl']) ? $data['configUrl'] : null;
        $this->container['configLogo'] = isset($data['configLogo']) ? $data['configLogo'] : null;
        $this->container['configLanguage'] = isset($data['configLanguage']) ? $data['configLanguage'] : null;
        $this->container['configCurrency'] = isset($data['configCurrency']) ? $data['configCurrency'] : null;
        $this->container['configProductLimit'] = isset($data['configProductLimit']) ? $data['configProductLimit'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets configTemplate
     *
     * @return string|null
     */
    public function getConfigTemplate()
    {
        return $this->container['configTemplate'];
    }

    /**
     * Sets configTemplate
     *
     * @param string|null $configTemplate Template
     *
     * @return $this
     */
    public function setConfigTemplate($configTemplate)
    {
        $this->container['configTemplate'] = $configTemplate;

        return $this;
    }

    /**
     * Gets configMetaKeyword
     *
     * @return string|null
     */
    public function getConfigMetaKeyword()
    {
        return $this->container['configMetaKeyword'];
    }

    /**
     * Sets configMetaKeyword
     *
     * @param string|null $configMetaKeyword Meta Tag Keywords
     *
     * @return $this
     */
    public function setConfigMetaKeyword($configMetaKeyword)
    {
        $this->container['configMetaKeyword'] = $configMetaKeyword;

        return $this;
    }

    /**
     * Gets configMetaDescription
     *
     * @return string|null
     */
    public function getConfigMetaDescription()
    {
        return $this->container['configMetaDescription'];
    }

    /**
     * Sets configMetaDescription
     *
     * @param string|null $configMetaDescription Meta Tag Description
     *
     * @return $this
     */
    public function setConfigMetaDescription($configMetaDescription)
    {
        $this->container['configMetaDescription'] = $configMetaDescription;

        return $this;
    }

    /**
     * Gets configMetaTitle
     *
     * @return string|null
     */
    public function getConfigMetaTitle()
    {
        return $this->container['configMetaTitle'];
    }

    /**
     * Sets configMetaTitle
     *
     * @param string|null $configMetaTitle Meta Title
     *
     * @return $this
     */
    public function setConfigMetaTitle($configMetaTitle)
    {
        $this->container['configMetaTitle'] = $configMetaTitle;

        return $this;
    }

    /**
     * Gets configImage
     *
     * @return string|null
     */
    public function getConfigImage()
    {
        return $this->container['configImage'];
    }

    /**
     * Sets configImage
     *
     * @param string|null $configImage Image
     *
     * @return $this
     */
    public function setConfigImage($configImage)
    {
        $this->container['configImage'] = $configImage;

        return $this;
    }

    /**
     * Gets configFax
     *
     * @return string|null
     */
    public function getConfigFax()
    {
        return $this->container['configFax'];
    }

    /**
     * Sets configFax
     *
     * @param string|null $configFax Fax
     *
     * @return $this
     */
    public function setConfigFax($configFax)
    {
        $this->container['configFax'] = $configFax;

        return $this;
    }

    /**
     * Gets configTelephone
     *
     * @return string|null
     */
    public function getConfigTelephone()
    {
        return $this->container['configTelephone'];
    }

    /**
     * Sets configTelephone
     *
     * @param string|null $configTelephone Telephones
     *
     * @return $this
     */
    public function setConfigTelephone($configTelephone)
    {
        $this->container['configTelephone'] = $configTelephone;

        return $this;
    }

    /**
     * Gets configEmail
     *
     * @return string|null
     */
    public function getConfigEmail()
    {
        return $this->container['configEmail'];
    }

    /**
     * Sets configEmail
     *
     * @param string|null $configEmail E-Mail
     *
     * @return $this
     */
    public function setConfigEmail($configEmail)
    {
        $this->container['configEmail'] = $configEmail;

        return $this;
    }

    /**
     * Gets configAddress
     *
     * @return string|null
     */
    public function getConfigAddress()
    {
        return $this->container['configAddress'];
    }

    /**
     * Sets configAddress
     *
     * @param string|null $configAddress Address
     *
     * @return $this
     */
    public function setConfigAddress($configAddress)
    {
        $this->container['configAddress'] = $configAddress;

        return $this;
    }

    /**
     * Gets configGeocode
     *
     * @return string|null
     */
    public function getConfigGeocode()
    {
        return $this->container['configGeocode'];
    }

    /**
     * Sets configGeocode
     *
     * @param string|null $configGeocode Geocode
     *
     * @return $this
     */
    public function setConfigGeocode($configGeocode)
    {
        $this->container['configGeocode'] = $configGeocode;

        return $this;
    }

    /**
     * Gets configOwner
     *
     * @return string|null
     */
    public function getConfigOwner()
    {
        return $this->container['configOwner'];
    }

    /**
     * Sets configOwner
     *
     * @param string|null $configOwner Store Owner
     *
     * @return $this
     */
    public function setConfigOwner($configOwner)
    {
        $this->container['configOwner'] = $configOwner;

        return $this;
    }

    /**
     * Gets configName
     *
     * @return string|null
     */
    public function getConfigName()
    {
        return $this->container['configName'];
    }

    /**
     * Sets configName
     *
     * @param string|null $configName Store Name
     *
     * @return $this
     */
    public function setConfigName($configName)
    {
        $this->container['configName'] = $configName;

        return $this;
    }

    /**
     * Gets configSsl
     *
     * @return string|null
     */
    public function getConfigSsl()
    {
        return $this->container['configSsl'];
    }

    /**
     * Sets configSsl
     *
     * @param string|null $configSsl Use SSL
     *
     * @return $this
     */
    public function setConfigSsl($configSsl)
    {
        $this->container['configSsl'] = $configSsl;

        return $this;
    }

    /**
     * Gets configUrl
     *
     * @return string|null
     */
    public function getConfigUrl()
    {
        return $this->container['configUrl'];
    }

    /**
     * Sets configUrl
     *
     * @param string|null $configUrl Store URL
     *
     * @return $this
     */
    public function setConfigUrl($configUrl)
    {
        $this->container['configUrl'] = $configUrl;

        return $this;
    }

    /**
     * Gets configLogo
     *
     * @return string|null
     */
    public function getConfigLogo()
    {
        return $this->container['configLogo'];
    }

    /**
     * Sets configLogo
     *
     * @param string|null $configLogo Store logo
     *
     * @return $this
     */
    public function setConfigLogo($configLogo)
    {
        $this->container['configLogo'] = $configLogo;

        return $this;
    }

    /**
     * Gets configLanguage
     *
     * @return string|null
     */
    public function getConfigLanguage()
    {
        return $this->container['configLanguage'];
    }

    /**
     * Sets configLanguage
     *
     * @param string|null $configLanguage Language
     *
     * @return $this
     */
    public function setConfigLanguage($configLanguage)
    {
        $this->container['configLanguage'] = $configLanguage;

        return $this;
    }

    /**
     * Gets configCurrency
     *
     * @return string|null
     */
    public function getConfigCurrency()
    {
        return $this->container['configCurrency'];
    }

    /**
     * Sets configCurrency
     *
     * @param string|null $configCurrency Currency
     *
     * @return $this
     */
    public function setConfigCurrency($configCurrency)
    {
        $this->container['configCurrency'] = $configCurrency;

        return $this;
    }

    /**
     * Gets configProductLimit
     *
     * @return int|null
     */
    public function getConfigProductLimit()
    {
        return $this->container['configProductLimit'];
    }

    /**
     * Sets configProductLimit
     *
     * @param int|null $configProductLimit Default Items Per Page (Catalog)
     *
     * @return $this
     */
    public function setConfigProductLimit($configProductLimit)
    {
        $this->container['configProductLimit'] = $configProductLimit;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


