# RTMTrade\OpenCart\AdminApi\PaymentMethodApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**paymentmethodsList**](PaymentMethodApi.md#paymentmethodsList) | **GET** /paymentmethods | Get payment methods



## paymentmethodsList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse paymentmethodsList()

Get payment methods

<span class=\"bold\">Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/paymentmethods</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/payment_method_admin/paymentmethods</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\PaymentMethodApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->paymentmethodsList();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PaymentMethodApi->paymentmethodsList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

