# RTMTrade\OpenCart\AdminApi\OrderApi

All URIs are relative to *https://api-oauth.opencart-api.com/api/rest_admin*

Method | HTTP request | Description
------------- | ------------- | -------------
[**invoiceCreate**](OrderApi.md#invoiceCreate) | **POST** /orders/invoice/{id} | Generate invoice number to the orders
[**invoiceUpdate**](OrderApi.md#invoiceUpdate) | **PUT** /orders/invoice/{id} | Set custom invoice number to the orders
[**orderhistoryUpdate**](OrderApi.md#orderhistoryUpdate) | **PUT** /orderhistory/{id} | Add order history
[**ordersDelete**](OrderApi.md#ordersDelete) | **DELETE** /orders/{id} | Delete order by ID
[**ordersDetails**](OrderApi.md#ordersDetails) | **GET** /orders/{id} | Get order details by ID
[**ordersDetailsByCustomer**](OrderApi.md#ordersDetailsByCustomer) | **GET** /orders/user/{id} | Get order details by customer ID
[**ordersList**](OrderApi.md#ordersList) | **GET** /orders | Get list of orders
[**ordersListAddedBetween**](OrderApi.md#ordersListAddedBetween) | **GET** /orders/added_from/{added_from}/added_to/{added_to} | Get list of orders filtered by date parameter (between)
[**ordersListAddedFrom**](OrderApi.md#ordersListAddedFrom) | **GET** /orders/added_from/{added_from} | Get list of orders filtered by date parameter (from)
[**ordersListAddedOn**](OrderApi.md#ordersListAddedOn) | **GET** /orders/added_on/{added_on} | Get list of orders filtered by  date parameter (on)
[**ordersListDetails**](OrderApi.md#ordersListDetails) | **GET** /orders/details | Get list of orders with details
[**ordersListDetailsAddedBetween**](OrderApi.md#ordersListDetailsAddedBetween) | **GET** /orders/details/added_from/{added_from}/added_to/{added_to} | Get list of orders with details filtered by date parameter (between)
[**ordersListDetailsAddedFrom**](OrderApi.md#ordersListDetailsAddedFrom) | **GET** /orders/details/added_from/{added_from} | Get list of orders with details filtered by date parameter (from)
[**ordersListDetailsAddedOn**](OrderApi.md#ordersListDetailsAddedOn) | **GET** /orders/details/added_on/{added_on} | Get list of orders with details filtered by  date parameter (on)
[**ordersListDetailsIdLargerThan**](OrderApi.md#ordersListDetailsIdLargerThan) | **GET** /orders/details/id_larger_than/{id} | Get list of orders with id larger than {id}
[**ordersListDetailsIdLowerThan**](OrderApi.md#ordersListDetailsIdLowerThan) | **GET** /orders/details/id_lower_than/{id} | Get list of orders with id lower than {id}
[**ordersListDetailsModifiedBetween**](OrderApi.md#ordersListDetailsModifiedBetween) | **GET** /orders/details/modified_from/{modified_from}/modified_to/{modified_to} | Get list of orders with details filtered by modified date parameter (between)
[**ordersListDetailsModifiedFrom**](OrderApi.md#ordersListDetailsModifiedFrom) | **GET** /orders/details/modified_from/{modified_from} | Get list of orders with details filtered by modified date parameter (from)
[**ordersListDetailsModifiedOn**](OrderApi.md#ordersListDetailsModifiedOn) | **GET** /orders/details/modified_on/{modified_on} | Get list of orders with details filtered by modified date parameter (on)
[**ordersListDetailsStatusId**](OrderApi.md#ordersListDetailsStatusId) | **GET** /orders/details/status/{status_id} | Get list of orders with details filtered by status id
[**ordersListIdLargerThan**](OrderApi.md#ordersListIdLargerThan) | **GET** /orders/id_larger_than/{id} | Get list of orders with id larger than {id}
[**ordersListIdLowerThan**](OrderApi.md#ordersListIdLowerThan) | **GET** /orders/id_lower_than/{id} | Get list of orders with id lower than {id}
[**ordersListModifiedBetween**](OrderApi.md#ordersListModifiedBetween) | **GET** /orders/modified_from/{modified_from}/modified_to/{modified_to} | Get list of orders filtered by modified date parameter (between)
[**ordersListModifiedFrom**](OrderApi.md#ordersListModifiedFrom) | **GET** /orders/modified_from/{modified_from} | Get list of orders filtered by modified date parameter (from)
[**ordersListModifiedOn**](OrderApi.md#ordersListModifiedOn) | **GET** /orders/modified_on/{modified_on} | Get list of orders filtered by modified date parameter (on)
[**ordersListPagination**](OrderApi.md#ordersListPagination) | **GET** /orders/limit/{limit}/page/{page} | Get list of orders
[**ordersListPaginationDetailed**](OrderApi.md#ordersListPaginationDetailed) | **GET** /orders/details/limit/{limit}/page/{page} | Get list of orders
[**ordersListStatusId**](OrderApi.md#ordersListStatusId) | **GET** /orders/status/{status_id} | Get list of orders filtered by status id
[**ordersUpdate**](OrderApi.md#ordersUpdate) | **PUT** /orders/{id} | Update order by ID
[**ordersUpdateStatus**](OrderApi.md#ordersUpdateStatus) | **PUT** /order_status/{id} | Update order status by order ID
[**ordersUpdateTrackingnumber**](OrderApi.md#ordersUpdateTrackingnumber) | **PUT** /trackingnumber/{id} | Update order tracking number by order ID



## invoiceCreate

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse invoiceCreate($id)

Generate invoice number to the orders

It generates an invoice number for the order.<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/invoice/{order_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/invoice&id={order_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order Id

try {
    $result = $apiInstance->invoiceCreate($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->invoiceCreate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## invoiceUpdate

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse invoiceUpdate($id, $invoiceNumberObject)

Set custom invoice number to the orders

You can set your custom invoice number to the order.<br><br><span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/invoice/{order_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/invoice&id={order_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order Id
$invoiceNumberObject = new \RTMTrade\OpenCart\AdminApi\Model\InvoiceNumber(); // \RTMTrade\OpenCart\AdminApi\Model\InvoiceNumber | Invoice number object

try {
    $result = $apiInstance->invoiceUpdate($id, $invoiceNumberObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->invoiceUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order Id |
 **invoiceNumberObject** | [**\RTMTrade\OpenCart\AdminApi\Model\InvoiceNumber**](../Model/InvoiceNumber.md)| Invoice number object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## orderhistoryUpdate

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse orderhistoryUpdate($id, $historyObject)

Add order history

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orderhistory/{order_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orderhistory&id={order_id}</span><br/>Set 'notify' value to 1, to send notification to your customer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order Id
$historyObject = new \RTMTrade\OpenCart\AdminApi\Model\History(); // \RTMTrade\OpenCart\AdminApi\Model\History | History object

try {
    $result = $apiInstance->orderhistoryUpdate($id, $historyObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->orderhistoryUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order Id |
 **historyObject** | [**\RTMTrade\OpenCart\AdminApi\Model\History**](../Model/History.md)| History object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersDelete

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersDelete($id)

Delete order by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/{order_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&id={order_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order Id

try {
    $result = $apiInstance->ordersDelete($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersDetails

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersDetails($id)

Get order details by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/{order_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&id={order_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order Id

try {
    $result = $apiInstance->ordersDetails($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersDetailsByCustomer

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersDetailsByCustomer($id)

Get order details by customer ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/user/{user_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/userorders&user={user_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Customer Id

try {
    $result = $apiInstance->ordersDetailsByCustomer($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersDetailsByCustomer: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Customer Id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersList

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersList()

Get list of orders

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->ordersList();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersList: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListAddedBetween

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListAddedBetween($addedFrom, $addedTo)

Get list of orders filtered by date parameter (between)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/added_from/{added_from}/added_to/{added_to}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&filter_date_added_from={added_from}&filter_date_added_to={added_to}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$addedFrom = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | From date added
$addedTo = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | To date added

try {
    $result = $apiInstance->ordersListAddedBetween($addedFrom, $addedTo);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListAddedBetween: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addedFrom** | **\DateTime**| From date added |
 **addedTo** | **\DateTime**| To date added |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListAddedFrom

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListAddedFrom($addedFrom)

Get list of orders filtered by date parameter (from)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/added_from/{added_from}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&filter_date_added_from={added_from}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$addedFrom = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | From date added

try {
    $result = $apiInstance->ordersListAddedFrom($addedFrom);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListAddedFrom: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addedFrom** | **\DateTime**| From date added |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListAddedOn

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListAddedOn($addedOn)

Get list of orders filtered by  date parameter (on)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/added_on/{added_on}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&filter_date_added_on={added_on}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$addedOn = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Orders added on date

try {
    $result = $apiInstance->ordersListAddedOn($addedOn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListAddedOn: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addedOn** | **\DateTime**| Orders added on date |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListDetails

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListDetails()

Get list of orders with details

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/details</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/listorderswithdetails</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->ordersListDetails();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListDetailsAddedBetween

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListDetailsAddedBetween($addedFrom, $addedTo)

Get list of orders with details filtered by date parameter (between)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/details/added_from/{added_from}/added_to/{added_to}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/listorderswithdetails&filter_date_added_from={added_from}&filter_date_added_to={added_to}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$addedFrom = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | From date added
$addedTo = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | To date added

try {
    $result = $apiInstance->ordersListDetailsAddedBetween($addedFrom, $addedTo);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListDetailsAddedBetween: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addedFrom** | **\DateTime**| From date added |
 **addedTo** | **\DateTime**| To date added |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListDetailsAddedFrom

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListDetailsAddedFrom($addedFrom)

Get list of orders with details filtered by date parameter (from)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/details/added_from/{added_from}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/listorderswithdetails&filter_date_added_from={added_from}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$addedFrom = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | From date added

try {
    $result = $apiInstance->ordersListDetailsAddedFrom($addedFrom);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListDetailsAddedFrom: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addedFrom** | **\DateTime**| From date added |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListDetailsAddedOn

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListDetailsAddedOn($addedOn)

Get list of orders with details filtered by  date parameter (on)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/details/added_on/{added_on}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/listorderswithdetails&filter_date_added_on={added_on}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$addedOn = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Orders added on date

try {
    $result = $apiInstance->ordersListDetailsAddedOn($addedOn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListDetailsAddedOn: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **addedOn** | **\DateTime**| Orders added on date |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListDetailsIdLargerThan

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListDetailsIdLargerThan($id)

Get list of orders with id larger than {id}

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/details/id_larger_than/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/listorderswithdetails&filter_id_larger_than={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order id

try {
    $result = $apiInstance->ordersListDetailsIdLargerThan($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListDetailsIdLargerThan: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListDetailsIdLowerThan

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListDetailsIdLowerThan($id)

Get list of orders with id lower than {id}

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/details/id_lower_than/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/listorderswithdetails&filter_id_lower_than={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order id

try {
    $result = $apiInstance->ordersListDetailsIdLowerThan($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListDetailsIdLowerThan: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListDetailsModifiedBetween

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListDetailsModifiedBetween($modifiedFrom, $modifiedTo)

Get list of orders with details filtered by modified date parameter (between)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/details/modified_from/{modified_from}/modified_to/{modified_to}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/listorderswithdetails&filter_date_modified_from={modified_from}&filter_date_modified_to={modified_to}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$modifiedFrom = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | From date modified
$modifiedTo = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | To date modified

try {
    $result = $apiInstance->ordersListDetailsModifiedBetween($modifiedFrom, $modifiedTo);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListDetailsModifiedBetween: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **modifiedFrom** | **\DateTime**| From date modified |
 **modifiedTo** | **\DateTime**| To date modified |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListDetailsModifiedFrom

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListDetailsModifiedFrom($modifiedFrom)

Get list of orders with details filtered by modified date parameter (from)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/details/modified_from/{modified_from}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/listorderswithdetails&filter_date_modified_from={modified_from}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$modifiedFrom = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | From date modified

try {
    $result = $apiInstance->ordersListDetailsModifiedFrom($modifiedFrom);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListDetailsModifiedFrom: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **modifiedFrom** | **\DateTime**| From date modified |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListDetailsModifiedOn

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListDetailsModifiedOn($modifiedOn)

Get list of orders with details filtered by modified date parameter (on)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/details/modified_on/{modified_on}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/listorderswithdetails&filter_date_modified_on={modified_on}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$modifiedOn = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Orders modified on date

try {
    $result = $apiInstance->ordersListDetailsModifiedOn($modifiedOn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListDetailsModifiedOn: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **modifiedOn** | **\DateTime**| Orders modified on date |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListDetailsStatusId

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListDetailsStatusId($statusId)

Get list of orders with details filtered by status id

You can send only one status, or you can send more statuses with comma separated.<br><span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/details/status/{status_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/listorderswithdetails&filter_order_status_id={status_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$statusId = 'statusId_example'; // string | Order status id or ids

try {
    $result = $apiInstance->ordersListDetailsStatusId($statusId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListDetailsStatusId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **statusId** | **string**| Order status id or ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListIdLargerThan

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListIdLargerThan($id)

Get list of orders with id larger than {id}

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/id_larger_than/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&filter_id_larger_than={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order id

try {
    $result = $apiInstance->ordersListIdLargerThan($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListIdLargerThan: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListIdLowerThan

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListIdLowerThan($id)

Get list of orders with id lower than {id}

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/id_lower_than/{id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&filter_id_lower_than={id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order id

try {
    $result = $apiInstance->ordersListIdLowerThan($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListIdLowerThan: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order id |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListModifiedBetween

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListModifiedBetween($modifiedFrom, $modifiedTo)

Get list of orders filtered by modified date parameter (between)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/modified_from/{modified_from}/modified_to/{modified_to}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&filter_date_modified_from={modified_from}&filter_date_modified_to={modified_to}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$modifiedFrom = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | From date modified
$modifiedTo = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | To date modified

try {
    $result = $apiInstance->ordersListModifiedBetween($modifiedFrom, $modifiedTo);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListModifiedBetween: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **modifiedFrom** | **\DateTime**| From date modified |
 **modifiedTo** | **\DateTime**| To date modified |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListModifiedFrom

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListModifiedFrom($modifiedFrom)

Get list of orders filtered by modified date parameter (from)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/modified_from/{modified_from}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&filter_date_modified_from={modified_from}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$modifiedFrom = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | From date modified

try {
    $result = $apiInstance->ordersListModifiedFrom($modifiedFrom);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListModifiedFrom: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **modifiedFrom** | **\DateTime**| From date modified |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListModifiedOn

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListModifiedOn($modifiedOn)

Get list of orders filtered by modified date parameter (on)

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/modified_on/{modified_on}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&filter_date_modified_on={modified_on}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$modifiedOn = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Orders modified on date

try {
    $result = $apiInstance->ordersListModifiedOn($modifiedOn);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListModifiedOn: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **modifiedOn** | **\DateTime**| Orders modified on date |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListPagination

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListPagination($limit, $page)

Get list of orders

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->ordersListPagination($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListPagination: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListPaginationDetailed

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListPaginationDetailed($limit, $page)

Get list of orders

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/limit/{limit}/page/{page}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&limit={limit}&page={page}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 10; // int | Limit
$page = 1; // int | Page

try {
    $result = $apiInstance->ordersListPaginationDetailed($limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListPaginationDetailed: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| Limit | [default to 10]
 **page** | **int**| Page | [default to 1]

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersListStatusId

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersListStatusId($statusId)

Get list of orders filtered by status id

You can send only one status, or you can send more statuses with comma separated.<br><span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/status/{status_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&filter_order_status_id={status_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$statusId = 'statusId_example'; // string | Order status id or ids

try {
    $result = $apiInstance->ordersListStatusId($statusId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersListStatusId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **statusId** | **string**| Order status id or ids |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersUpdate

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersUpdate($id, $orderStatusObject)

Update order by ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/orders/{order_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orders&id={order_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order Id
$orderStatusObject = new \RTMTrade\OpenCart\AdminApi\Model\OrderStatusSetter(); // \RTMTrade\OpenCart\AdminApi\Model\OrderStatusSetter | Order status object

try {
    $result = $apiInstance->ordersUpdate($id, $orderStatusObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersUpdate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order Id |
 **orderStatusObject** | [**\RTMTrade\OpenCart\AdminApi\Model\OrderStatusSetter**](../Model/OrderStatusSetter.md)| Order status object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersUpdateStatus

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersUpdateStatus($id, $orderStatusObject)

Update order status by order ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/order_status/{order_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/orderstatus&id={order_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order Id
$orderStatusObject = new \RTMTrade\OpenCart\AdminApi\Model\OrderStatusSetterName(); // \RTMTrade\OpenCart\AdminApi\Model\OrderStatusSetterName | Order status object

try {
    $result = $apiInstance->ordersUpdateStatus($id, $orderStatusObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersUpdateStatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order Id |
 **orderStatusObject** | [**\RTMTrade\OpenCart\AdminApi\Model\OrderStatusSetterName**](../Model/OrderStatusSetterName.md)| Order status object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)


## ordersUpdateTrackingnumber

> \RTMTrade\OpenCart\AdminApi\Model\ApiResponse ordersUpdateTrackingnumber($id, $orderTrackingNumberObject)

Update order tracking number by order ID

<span class='bold'>Service urls:</span><br><span class='links'>http://yourdomain.com/api/rest_admin/trackingnumber/{order_id}</span><br>OR<br><span class='links'>http://yourdomain.com/index.php?route=rest/order_admin/trackingnumber&id={order_id}</span>

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: Bearer
$config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = RTMTrade\OpenCart\AdminApi\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new RTMTrade\OpenCart\AdminApi\Api\OrderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | Order Id
$orderTrackingNumberObject = new \RTMTrade\OpenCart\AdminApi\Model\OrdertrackingnumberSetter(); // \RTMTrade\OpenCart\AdminApi\Model\OrdertrackingnumberSetter | Order tracking number object

try {
    $result = $apiInstance->ordersUpdateTrackingnumber($id, $orderTrackingNumberObject);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OrderApi->ordersUpdateTrackingnumber: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Order Id |
 **orderTrackingNumberObject** | [**\RTMTrade\OpenCart\AdminApi\Model\OrdertrackingnumberSetter**](../Model/OrdertrackingnumberSetter.md)| Order tracking number object |

### Return type

[**\RTMTrade\OpenCart\AdminApi\Model\ApiResponse**](../Model/ApiResponse.md)

### Authorization

[Bearer](../../README.md#Bearer)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints)
[[Back to Model list]](../../README.md#documentation-for-models)
[[Back to README]](../../README.md)

