<?php
/**
 * CouponEditObject
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

use \ArrayAccess;
use \RTMTrade\OpenCart\AdminApi\ObjectSerializer;

/**
 * CouponEditObject Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CouponEditObject implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CouponEditObject';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'code' => 'string',
        'type' => 'string',
        'discount' => 'string',
        'total' => 'string',
        'logged' => 'int',
        'shipping' => 'int',
        'couponProduct' => 'int[]',
        'couponCategory' => 'int[]',
        'dateStart' => 'string',
        'dateEnd' => 'string',
        'usesTotal' => 'int',
        'usesCustomer' => 'int',
        'status' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'name' => null,
        'code' => null,
        'type' => null,
        'discount' => null,
        'total' => null,
        'logged' => 'int32',
        'shipping' => 'int32',
        'couponProduct' => 'int32',
        'couponCategory' => 'int32',
        'dateStart' => null,
        'dateEnd' => null,
        'usesTotal' => 'int32',
        'usesCustomer' => 'int32',
        'status' => 'int32'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'code' => 'code',
        'type' => 'type',
        'discount' => 'discount',
        'total' => 'total',
        'logged' => 'logged',
        'shipping' => 'shipping',
        'couponProduct' => 'coupon_product',
        'couponCategory' => 'coupon_category',
        'dateStart' => 'date_start',
        'dateEnd' => 'date_end',
        'usesTotal' => 'uses_total',
        'usesCustomer' => 'uses_customer',
        'status' => 'status'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'code' => 'setCode',
        'type' => 'setType',
        'discount' => 'setDiscount',
        'total' => 'setTotal',
        'logged' => 'setLogged',
        'shipping' => 'setShipping',
        'couponProduct' => 'setCouponProduct',
        'couponCategory' => 'setCouponCategory',
        'dateStart' => 'setDateStart',
        'dateEnd' => 'setDateEnd',
        'usesTotal' => 'setUsesTotal',
        'usesCustomer' => 'setUsesCustomer',
        'status' => 'setStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'code' => 'getCode',
        'type' => 'getType',
        'discount' => 'getDiscount',
        'total' => 'getTotal',
        'logged' => 'getLogged',
        'shipping' => 'getShipping',
        'couponProduct' => 'getCouponProduct',
        'couponCategory' => 'getCouponCategory',
        'dateStart' => 'getDateStart',
        'dateEnd' => 'getDateEnd',
        'usesTotal' => 'getUsesTotal',
        'usesCustomer' => 'getUsesCustomer',
        'status' => 'getStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['code'] = isset($data['code']) ? $data['code'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : 'P';
        $this->container['discount'] = isset($data['discount']) ? $data['discount'] : '0';
        $this->container['total'] = isset($data['total']) ? $data['total'] : '0';
        $this->container['logged'] = isset($data['logged']) ? $data['logged'] : 0;
        $this->container['shipping'] = isset($data['shipping']) ? $data['shipping'] : 0;
        $this->container['couponProduct'] = isset($data['couponProduct']) ? $data['couponProduct'] : null;
        $this->container['couponCategory'] = isset($data['couponCategory']) ? $data['couponCategory'] : null;
        $this->container['dateStart'] = isset($data['dateStart']) ? $data['dateStart'] : null;
        $this->container['dateEnd'] = isset($data['dateEnd']) ? $data['dateEnd'] : null;
        $this->container['usesTotal'] = isset($data['usesTotal']) ? $data['usesTotal'] : 1;
        $this->container['usesCustomer'] = isset($data['usesCustomer']) ? $data['usesCustomer'] : 1;
        $this->container['status'] = isset($data['status']) ? $data['status'] : 1;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name coupon name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code The code the customer enters to get the discount.
     *
     * @return $this
     */
    public function setCode($code)
    {
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type Percentage (P) or Fixed Amount (F).
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return string|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param string|null $discount Discount
     *
     * @return $this
     */
    public function setDiscount($discount)
    {
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets total
     *
     * @return string|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param string|null $total The total amount that must be reached before the coupon is valid.
     *
     * @return $this
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets logged
     *
     * @return int|null
     */
    public function getLogged()
    {
        return $this->container['logged'];
    }

    /**
     * Sets logged
     *
     * @param int|null $logged Customer must be logged in to use the coupon.
     *
     * @return $this
     */
    public function setLogged($logged)
    {
        $this->container['logged'] = $logged;

        return $this;
    }

    /**
     * Gets shipping
     *
     * @return int|null
     */
    public function getShipping()
    {
        return $this->container['shipping'];
    }

    /**
     * Sets shipping
     *
     * @param int|null $shipping Free Shipping
     *
     * @return $this
     */
    public function setShipping($shipping)
    {
        $this->container['shipping'] = $shipping;

        return $this;
    }

    /**
     * Gets couponProduct
     *
     * @return int[]|null
     */
    public function getCouponProduct()
    {
        return $this->container['couponProduct'];
    }

    /**
     * Sets couponProduct
     *
     * @param int[]|null $couponProduct Set specific product ids the coupon will apply to. Select no products to apply coupon to entire cart.
     *
     * @return $this
     */
    public function setCouponProduct($couponProduct)
    {
        $this->container['couponProduct'] = $couponProduct;

        return $this;
    }

    /**
     * Gets couponCategory
     *
     * @return int[]|null
     */
    public function getCouponCategory()
    {
        return $this->container['couponCategory'];
    }

    /**
     * Sets couponCategory
     *
     * @param int[]|null $couponCategory Choose all products under selected category ids
     *
     * @return $this
     */
    public function setCouponCategory($couponCategory)
    {
        $this->container['couponCategory'] = $couponCategory;

        return $this;
    }

    /**
     * Gets dateStart
     *
     * @return string|null
     */
    public function getDateStart()
    {
        return $this->container['dateStart'];
    }

    /**
     * Sets dateStart
     *
     * @param string|null $dateStart Date start
     *
     * @return $this
     */
    public function setDateStart($dateStart)
    {
        $this->container['dateStart'] = $dateStart;

        return $this;
    }

    /**
     * Gets dateEnd
     *
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->container['dateEnd'];
    }

    /**
     * Sets dateEnd
     *
     * @param string|null $dateEnd Date end
     *
     * @return $this
     */
    public function setDateEnd($dateEnd)
    {
        $this->container['dateEnd'] = $dateEnd;

        return $this;
    }

    /**
     * Gets usesTotal
     *
     * @return int|null
     */
    public function getUsesTotal()
    {
        return $this->container['usesTotal'];
    }

    /**
     * Sets usesTotal
     *
     * @param int|null $usesTotal The maximum number of times the coupon can be used by any customer. Leave blank for unlimited
     *
     * @return $this
     */
    public function setUsesTotal($usesTotal)
    {
        $this->container['usesTotal'] = $usesTotal;

        return $this;
    }

    /**
     * Gets usesCustomer
     *
     * @return int|null
     */
    public function getUsesCustomer()
    {
        return $this->container['usesCustomer'];
    }

    /**
     * Sets usesCustomer
     *
     * @param int|null $usesCustomer The maximum number of times the coupon can be used by a single customer. Leave blank for unlimited
     *
     * @return $this
     */
    public function setUsesCustomer($usesCustomer)
    {
        $this->container['usesCustomer'] = $usesCustomer;

        return $this;
    }

    /**
     * Gets status
     *
     * @return int|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param int|null $status Status (1-enabled, 0-disabled)
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


