<?php
/**
 * BulkProductEditObject
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Documentation of Opencart Rest Admin Api (OAuth version)
 *
 * For this demo, first you have to call the `Token` service to get an access token.<br>Then click on the `Authorize` button and set the Bearer Token, for example: <strong>`Bearer 7487c50afc37dbf6e5a484dc49c363128036c356`</strong>.<br>Please do not forget the `Bearer` part, if you forget it, then you will get `Malformed auth header` error.<br>Then you have to call the `User` &rArr; `Login` service before you can access the other services.<br><div class=\"main_steps\">First step - Get access token</div><span class=\"method\">POST</span> <span class=\"links\">/oauth2/token/client_credentials</span> The received token needs to be added to every API call.<br><br><div class=\"main_steps\">Second step - Login user</div><span class=\"method\">POST</span> <span class=\"links\">/api/rest_admin/login</span> After successful login you can access the REST API services
 *
 * The version of the OpenAPI document: 1.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.0-beta
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace RTMTrade\OpenCart\AdminApi\Model;

use \ArrayAccess;
use \RTMTrade\OpenCart\AdminApi\ObjectSerializer;

/**
 * BulkProductEditObject Class Doc Comment
 *
 * @category Class
 * @package  RTMTrade\OpenCart\AdminApi
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BulkProductEditObject implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BulkProductEditObject';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'productId' => 'int',
        'model' => 'string',
        'quantity' => 'int',
        'price' => 'double',
        'taxClassId' => 'int',
        'manufacturerId' => 'int',
        'sku' => 'string',
        'keyword' => 'string',
        'status' => 'string',
        'points' => 'int',
        'reward' => 'int',
        'image' => 'string',
        'otherImages' => 'string[]',
        'shipping' => 'int',
        'stockStatusId' => 'int',
        'upc' => 'string',
        'ean' => 'string',
        'jan' => 'string',
        'isbn' => 'string',
        'mpn' => 'string',
        'location' => 'string',
        'dateAvailable' => '\DateTime',
        'weight' => 'double',
        'weightClassId' => 'int',
        'length' => 'double',
        'width' => 'double',
        'height' => 'double',
        'lengthClassId' => 'int',
        'subtract' => 'int',
        'minimum' => 'int',
        'sortOrder' => 'int',
        'productStore' => 'int[]',
        'productRelated' => 'int[]',
        'productFilter' => 'int[]',
        'productDescription' => '\RTMTrade\OpenCart\AdminApi\Model\ProductDescription[]',
        'productCategory' => 'int[]',
        'productSpecial' => '\RTMTrade\OpenCart\AdminApi\Model\ProductSpecial[]',
        'productDiscount' => '\RTMTrade\OpenCart\AdminApi\Model\ProductDiscount[]',
        'productAttribute' => '\RTMTrade\OpenCart\AdminApi\Model\ProductAttribute[]',
        'productOption' => '\RTMTrade\OpenCart\AdminApi\Model\ProductOptionData[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPIFormats = [
        'productId' => 'int32',
        'model' => null,
        'quantity' => 'int32',
        'price' => 'double',
        'taxClassId' => 'int32',
        'manufacturerId' => 'int32',
        'sku' => null,
        'keyword' => null,
        'status' => null,
        'points' => 'int32',
        'reward' => 'int32',
        'image' => null,
        'otherImages' => null,
        'shipping' => 'int32',
        'stockStatusId' => 'int32',
        'upc' => null,
        'ean' => null,
        'jan' => null,
        'isbn' => null,
        'mpn' => null,
        'location' => null,
        'dateAvailable' => 'date',
        'weight' => 'double',
        'weightClassId' => 'int32',
        'length' => 'double',
        'width' => 'double',
        'height' => 'double',
        'lengthClassId' => 'int32',
        'subtract' => 'int32',
        'minimum' => 'int32',
        'sortOrder' => 'int32',
        'productStore' => 'int32',
        'productRelated' => 'int32',
        'productFilter' => 'int32',
        'productDescription' => null,
        'productCategory' => 'int32',
        'productSpecial' => null,
        'productDiscount' => null,
        'productAttribute' => null,
        'productOption' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'productId' => 'product_id',
        'model' => 'model',
        'quantity' => 'quantity',
        'price' => 'price',
        'taxClassId' => 'tax_class_id',
        'manufacturerId' => 'manufacturer_id',
        'sku' => 'sku',
        'keyword' => 'keyword',
        'status' => 'status',
        'points' => 'points',
        'reward' => 'reward',
        'image' => 'image',
        'otherImages' => 'other_images',
        'shipping' => 'shipping',
        'stockStatusId' => 'stock_status_id',
        'upc' => 'upc',
        'ean' => 'ean',
        'jan' => 'jan',
        'isbn' => 'isbn',
        'mpn' => 'mpn',
        'location' => 'location',
        'dateAvailable' => 'date_available',
        'weight' => 'weight',
        'weightClassId' => 'weight_class_id',
        'length' => 'length',
        'width' => 'width',
        'height' => 'height',
        'lengthClassId' => 'length_class_id',
        'subtract' => 'subtract',
        'minimum' => 'minimum',
        'sortOrder' => 'sort_order',
        'productStore' => 'product_store',
        'productRelated' => 'product_related',
        'productFilter' => 'product_filter',
        'productDescription' => 'product_description',
        'productCategory' => 'product_category',
        'productSpecial' => 'product_special',
        'productDiscount' => 'product_discount',
        'productAttribute' => 'product_attribute',
        'productOption' => 'product_option'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'productId' => 'setProductId',
        'model' => 'setModel',
        'quantity' => 'setQuantity',
        'price' => 'setPrice',
        'taxClassId' => 'setTaxClassId',
        'manufacturerId' => 'setManufacturerId',
        'sku' => 'setSku',
        'keyword' => 'setKeyword',
        'status' => 'setStatus',
        'points' => 'setPoints',
        'reward' => 'setReward',
        'image' => 'setImage',
        'otherImages' => 'setOtherImages',
        'shipping' => 'setShipping',
        'stockStatusId' => 'setStockStatusId',
        'upc' => 'setUpc',
        'ean' => 'setEan',
        'jan' => 'setJan',
        'isbn' => 'setIsbn',
        'mpn' => 'setMpn',
        'location' => 'setLocation',
        'dateAvailable' => 'setDateAvailable',
        'weight' => 'setWeight',
        'weightClassId' => 'setWeightClassId',
        'length' => 'setLength',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'lengthClassId' => 'setLengthClassId',
        'subtract' => 'setSubtract',
        'minimum' => 'setMinimum',
        'sortOrder' => 'setSortOrder',
        'productStore' => 'setProductStore',
        'productRelated' => 'setProductRelated',
        'productFilter' => 'setProductFilter',
        'productDescription' => 'setProductDescription',
        'productCategory' => 'setProductCategory',
        'productSpecial' => 'setProductSpecial',
        'productDiscount' => 'setProductDiscount',
        'productAttribute' => 'setProductAttribute',
        'productOption' => 'setProductOption'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'productId' => 'getProductId',
        'model' => 'getModel',
        'quantity' => 'getQuantity',
        'price' => 'getPrice',
        'taxClassId' => 'getTaxClassId',
        'manufacturerId' => 'getManufacturerId',
        'sku' => 'getSku',
        'keyword' => 'getKeyword',
        'status' => 'getStatus',
        'points' => 'getPoints',
        'reward' => 'getReward',
        'image' => 'getImage',
        'otherImages' => 'getOtherImages',
        'shipping' => 'getShipping',
        'stockStatusId' => 'getStockStatusId',
        'upc' => 'getUpc',
        'ean' => 'getEan',
        'jan' => 'getJan',
        'isbn' => 'getIsbn',
        'mpn' => 'getMpn',
        'location' => 'getLocation',
        'dateAvailable' => 'getDateAvailable',
        'weight' => 'getWeight',
        'weightClassId' => 'getWeightClassId',
        'length' => 'getLength',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'lengthClassId' => 'getLengthClassId',
        'subtract' => 'getSubtract',
        'minimum' => 'getMinimum',
        'sortOrder' => 'getSortOrder',
        'productStore' => 'getProductStore',
        'productRelated' => 'getProductRelated',
        'productFilter' => 'getProductFilter',
        'productDescription' => 'getProductDescription',
        'productCategory' => 'getProductCategory',
        'productSpecial' => 'getProductSpecial',
        'productDiscount' => 'getProductDiscount',
        'productAttribute' => 'getProductAttribute',
        'productOption' => 'getProductOption'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['productId'] = isset($data['productId']) ? $data['productId'] : 30;
        $this->container['model'] = isset($data['model']) ? $data['model'] : null;
        $this->container['quantity'] = isset($data['quantity']) ? $data['quantity'] : 1;
        $this->container['price'] = isset($data['price']) ? $data['price'] : null;
        $this->container['taxClassId'] = isset($data['taxClassId']) ? $data['taxClassId'] : 0;
        $this->container['manufacturerId'] = isset($data['manufacturerId']) ? $data['manufacturerId'] : 0;
        $this->container['sku'] = isset($data['sku']) ? $data['sku'] : null;
        $this->container['keyword'] = isset($data['keyword']) ? $data['keyword'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : '1';
        $this->container['points'] = isset($data['points']) ? $data['points'] : null;
        $this->container['reward'] = isset($data['reward']) ? $data['reward'] : null;
        $this->container['image'] = isset($data['image']) ? $data['image'] : null;
        $this->container['otherImages'] = isset($data['otherImages']) ? $data['otherImages'] : null;
        $this->container['shipping'] = isset($data['shipping']) ? $data['shipping'] : 1;
        $this->container['stockStatusId'] = isset($data['stockStatusId']) ? $data['stockStatusId'] : 6;
        $this->container['upc'] = isset($data['upc']) ? $data['upc'] : null;
        $this->container['ean'] = isset($data['ean']) ? $data['ean'] : null;
        $this->container['jan'] = isset($data['jan']) ? $data['jan'] : null;
        $this->container['isbn'] = isset($data['isbn']) ? $data['isbn'] : null;
        $this->container['mpn'] = isset($data['mpn']) ? $data['mpn'] : null;
        $this->container['location'] = isset($data['location']) ? $data['location'] : null;
        $this->container['dateAvailable'] = isset($data['dateAvailable']) ? $data['dateAvailable'] : null;
        $this->container['weight'] = isset($data['weight']) ? $data['weight'] : null;
        $this->container['weightClassId'] = isset($data['weightClassId']) ? $data['weightClassId'] : null;
        $this->container['length'] = isset($data['length']) ? $data['length'] : null;
        $this->container['width'] = isset($data['width']) ? $data['width'] : null;
        $this->container['height'] = isset($data['height']) ? $data['height'] : null;
        $this->container['lengthClassId'] = isset($data['lengthClassId']) ? $data['lengthClassId'] : null;
        $this->container['subtract'] = isset($data['subtract']) ? $data['subtract'] : 1;
        $this->container['minimum'] = isset($data['minimum']) ? $data['minimum'] : 1;
        $this->container['sortOrder'] = isset($data['sortOrder']) ? $data['sortOrder'] : 1;
        $this->container['productStore'] = isset($data['productStore']) ? $data['productStore'] : null;
        $this->container['productRelated'] = isset($data['productRelated']) ? $data['productRelated'] : null;
        $this->container['productFilter'] = isset($data['productFilter']) ? $data['productFilter'] : null;
        $this->container['productDescription'] = isset($data['productDescription']) ? $data['productDescription'] : null;
        $this->container['productCategory'] = isset($data['productCategory']) ? $data['productCategory'] : null;
        $this->container['productSpecial'] = isset($data['productSpecial']) ? $data['productSpecial'] : null;
        $this->container['productDiscount'] = isset($data['productDiscount']) ? $data['productDiscount'] : null;
        $this->container['productAttribute'] = isset($data['productAttribute']) ? $data['productAttribute'] : null;
        $this->container['productOption'] = isset($data['productOption']) ? $data['productOption'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['productId'] === null) {
            $invalidProperties[] = "'productId' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets productId
     *
     * @return int
     */
    public function getProductId()
    {
        return $this->container['productId'];
    }

    /**
     * Sets productId
     *
     * @param int $productId Product Id
     *
     * @return $this
     */
    public function setProductId($productId)
    {
        $this->container['productId'] = $productId;

        return $this;
    }

    /**
     * Gets model
     *
     * @return string|null
     */
    public function getModel()
    {
        return $this->container['model'];
    }

    /**
     * Sets model
     *
     * @param string|null $model Product model
     *
     * @return $this
     */
    public function setModel($model)
    {
        $this->container['model'] = $model;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Quantity
     *
     * @return $this
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets price
     *
     * @return double|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param double|null $price Price
     *
     * @return $this
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets taxClassId
     *
     * @return int|null
     */
    public function getTaxClassId()
    {
        return $this->container['taxClassId'];
    }

    /**
     * Sets taxClassId
     *
     * @param int|null $taxClassId Tax Class Identifier
     *
     * @return $this
     */
    public function setTaxClassId($taxClassId)
    {
        $this->container['taxClassId'] = $taxClassId;

        return $this;
    }

    /**
     * Gets manufacturerId
     *
     * @return int|null
     */
    public function getManufacturerId()
    {
        return $this->container['manufacturerId'];
    }

    /**
     * Sets manufacturerId
     *
     * @param int|null $manufacturerId Manufacturer ID
     *
     * @return $this
     */
    public function setManufacturerId($manufacturerId)
    {
        $this->container['manufacturerId'] = $manufacturerId;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Stock Keeping Unit
     *
     * @return $this
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets keyword
     *
     * @return string|null
     */
    public function getKeyword()
    {
        return $this->container['keyword'];
    }

    /**
     * Sets keyword
     *
     * @param string|null $keyword SEO keyword
     *
     * @return $this
     */
    public function setKeyword($keyword)
    {
        $this->container['keyword'] = $keyword;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Product status (Acceptable values are: \"1-Enabled\", \"0-Disabled\")
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets points
     *
     * @return int|null
     */
    public function getPoints()
    {
        return $this->container['points'];
    }

    /**
     * Sets points
     *
     * @param int|null $points points
     *
     * @return $this
     */
    public function setPoints($points)
    {
        $this->container['points'] = $points;

        return $this;
    }

    /**
     * Gets reward
     *
     * @return int|null
     */
    public function getReward()
    {
        return $this->container['reward'];
    }

    /**
     * Sets reward
     *
     * @param int|null $reward reward
     *
     * @return $this
     */
    public function setReward($reward)
    {
        $this->container['reward'] = $reward;

        return $this;
    }

    /**
     * Gets image
     *
     * @return string|null
     */
    public function getImage()
    {
        return $this->container['image'];
    }

    /**
     * Sets image
     *
     * @param string|null $image primary image (relative URL)
     *
     * @return $this
     */
    public function setImage($image)
    {
        $this->container['image'] = $image;

        return $this;
    }

    /**
     * Gets otherImages
     *
     * @return string[]|null
     */
    public function getOtherImages()
    {
        return $this->container['otherImages'];
    }

    /**
     * Sets otherImages
     *
     * @param string[]|null $otherImages List of product other images (relative URL)
     *
     * @return $this
     */
    public function setOtherImages($otherImages)
    {
        $this->container['otherImages'] = $otherImages;

        return $this;
    }

    /**
     * Gets shipping
     *
     * @return int|null
     */
    public function getShipping()
    {
        return $this->container['shipping'];
    }

    /**
     * Sets shipping
     *
     * @param int|null $shipping Requires Shipping
     *
     * @return $this
     */
    public function setShipping($shipping)
    {
        $this->container['shipping'] = $shipping;

        return $this;
    }

    /**
     * Gets stockStatusId
     *
     * @return int|null
     */
    public function getStockStatusId()
    {
        return $this->container['stockStatusId'];
    }

    /**
     * Sets stockStatusId
     *
     * @param int|null $stockStatusId stock_status_id
     *
     * @return $this
     */
    public function setStockStatusId($stockStatusId)
    {
        $this->container['stockStatusId'] = $stockStatusId;

        return $this;
    }

    /**
     * Gets upc
     *
     * @return string|null
     */
    public function getUpc()
    {
        return $this->container['upc'];
    }

    /**
     * Sets upc
     *
     * @param string|null $upc upc
     *
     * @return $this
     */
    public function setUpc($upc)
    {
        $this->container['upc'] = $upc;

        return $this;
    }

    /**
     * Gets ean
     *
     * @return string|null
     */
    public function getEan()
    {
        return $this->container['ean'];
    }

    /**
     * Sets ean
     *
     * @param string|null $ean ean
     *
     * @return $this
     */
    public function setEan($ean)
    {
        $this->container['ean'] = $ean;

        return $this;
    }

    /**
     * Gets jan
     *
     * @return string|null
     */
    public function getJan()
    {
        return $this->container['jan'];
    }

    /**
     * Sets jan
     *
     * @param string|null $jan jan
     *
     * @return $this
     */
    public function setJan($jan)
    {
        $this->container['jan'] = $jan;

        return $this;
    }

    /**
     * Gets isbn
     *
     * @return string|null
     */
    public function getIsbn()
    {
        return $this->container['isbn'];
    }

    /**
     * Sets isbn
     *
     * @param string|null $isbn isbn
     *
     * @return $this
     */
    public function setIsbn($isbn)
    {
        $this->container['isbn'] = $isbn;

        return $this;
    }

    /**
     * Gets mpn
     *
     * @return string|null
     */
    public function getMpn()
    {
        return $this->container['mpn'];
    }

    /**
     * Sets mpn
     *
     * @param string|null $mpn mpn
     *
     * @return $this
     */
    public function setMpn($mpn)
    {
        $this->container['mpn'] = $mpn;

        return $this;
    }

    /**
     * Gets location
     *
     * @return string|null
     */
    public function getLocation()
    {
        return $this->container['location'];
    }

    /**
     * Sets location
     *
     * @param string|null $location location
     *
     * @return $this
     */
    public function setLocation($location)
    {
        $this->container['location'] = $location;

        return $this;
    }

    /**
     * Gets dateAvailable
     *
     * @return \DateTime|null
     */
    public function getDateAvailable()
    {
        return $this->container['dateAvailable'];
    }

    /**
     * Sets dateAvailable
     *
     * @param \DateTime|null $dateAvailable date_available
     *
     * @return $this
     */
    public function setDateAvailable($dateAvailable)
    {
        $this->container['dateAvailable'] = $dateAvailable;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return double|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param double|null $weight weight
     *
     * @return $this
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets weightClassId
     *
     * @return int|null
     */
    public function getWeightClassId()
    {
        return $this->container['weightClassId'];
    }

    /**
     * Sets weightClassId
     *
     * @param int|null $weightClassId weight_class_id
     *
     * @return $this
     */
    public function setWeightClassId($weightClassId)
    {
        $this->container['weightClassId'] = $weightClassId;

        return $this;
    }

    /**
     * Gets length
     *
     * @return double|null
     */
    public function getLength()
    {
        return $this->container['length'];
    }

    /**
     * Sets length
     *
     * @param double|null $length length
     *
     * @return $this
     */
    public function setLength($length)
    {
        $this->container['length'] = $length;

        return $this;
    }

    /**
     * Gets width
     *
     * @return double|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param double|null $width width
     *
     * @return $this
     */
    public function setWidth($width)
    {
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return double|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param double|null $height height
     *
     * @return $this
     */
    public function setHeight($height)
    {
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets lengthClassId
     *
     * @return int|null
     */
    public function getLengthClassId()
    {
        return $this->container['lengthClassId'];
    }

    /**
     * Sets lengthClassId
     *
     * @param int|null $lengthClassId length_class_id
     *
     * @return $this
     */
    public function setLengthClassId($lengthClassId)
    {
        $this->container['lengthClassId'] = $lengthClassId;

        return $this;
    }

    /**
     * Gets subtract
     *
     * @return int|null
     */
    public function getSubtract()
    {
        return $this->container['subtract'];
    }

    /**
     * Sets subtract
     *
     * @param int|null $subtract subtract
     *
     * @return $this
     */
    public function setSubtract($subtract)
    {
        $this->container['subtract'] = $subtract;

        return $this;
    }

    /**
     * Gets minimum
     *
     * @return int|null
     */
    public function getMinimum()
    {
        return $this->container['minimum'];
    }

    /**
     * Sets minimum
     *
     * @param int|null $minimum minimum
     *
     * @return $this
     */
    public function setMinimum($minimum)
    {
        $this->container['minimum'] = $minimum;

        return $this;
    }

    /**
     * Gets sortOrder
     *
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->container['sortOrder'];
    }

    /**
     * Sets sortOrder
     *
     * @param int|null $sortOrder Sort order
     *
     * @return $this
     */
    public function setSortOrder($sortOrder)
    {
        $this->container['sortOrder'] = $sortOrder;

        return $this;
    }

    /**
     * Gets productStore
     *
     * @return int[]|null
     */
    public function getProductStore()
    {
        return $this->container['productStore'];
    }

    /**
     * Sets productStore
     *
     * @param int[]|null $productStore List of stores
     *
     * @return $this
     */
    public function setProductStore($productStore)
    {
        $this->container['productStore'] = $productStore;

        return $this;
    }

    /**
     * Gets productRelated
     *
     * @return int[]|null
     */
    public function getProductRelated()
    {
        return $this->container['productRelated'];
    }

    /**
     * Sets productRelated
     *
     * @param int[]|null $productRelated List of related product ids
     *
     * @return $this
     */
    public function setProductRelated($productRelated)
    {
        $this->container['productRelated'] = $productRelated;

        return $this;
    }

    /**
     * Gets productFilter
     *
     * @return int[]|null
     */
    public function getProductFilter()
    {
        return $this->container['productFilter'];
    }

    /**
     * Sets productFilter
     *
     * @param int[]|null $productFilter List of product filter ids
     *
     * @return $this
     */
    public function setProductFilter($productFilter)
    {
        $this->container['productFilter'] = $productFilter;

        return $this;
    }

    /**
     * Gets productDescription
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\ProductDescription[]|null
     */
    public function getProductDescription()
    {
        return $this->container['productDescription'];
    }

    /**
     * Sets productDescription
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\ProductDescription[]|null $productDescription 
     *
     * @return $this
     */
    public function setProductDescription($productDescription)
    {
        $this->container['productDescription'] = $productDescription;

        return $this;
    }

    /**
     * Gets productCategory
     *
     * @return int[]|null
     */
    public function getProductCategory()
    {
        return $this->container['productCategory'];
    }

    /**
     * Sets productCategory
     *
     * @param int[]|null $productCategory List of categories
     *
     * @return $this
     */
    public function setProductCategory($productCategory)
    {
        $this->container['productCategory'] = $productCategory;

        return $this;
    }

    /**
     * Gets productSpecial
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\ProductSpecial[]|null
     */
    public function getProductSpecial()
    {
        return $this->container['productSpecial'];
    }

    /**
     * Sets productSpecial
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\ProductSpecial[]|null $productSpecial 
     *
     * @return $this
     */
    public function setProductSpecial($productSpecial)
    {
        $this->container['productSpecial'] = $productSpecial;

        return $this;
    }

    /**
     * Gets productDiscount
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\ProductDiscount[]|null
     */
    public function getProductDiscount()
    {
        return $this->container['productDiscount'];
    }

    /**
     * Sets productDiscount
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\ProductDiscount[]|null $productDiscount 
     *
     * @return $this
     */
    public function setProductDiscount($productDiscount)
    {
        $this->container['productDiscount'] = $productDiscount;

        return $this;
    }

    /**
     * Gets productAttribute
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\ProductAttribute[]|null
     */
    public function getProductAttribute()
    {
        return $this->container['productAttribute'];
    }

    /**
     * Sets productAttribute
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\ProductAttribute[]|null $productAttribute 
     *
     * @return $this
     */
    public function setProductAttribute($productAttribute)
    {
        $this->container['productAttribute'] = $productAttribute;

        return $this;
    }

    /**
     * Gets productOption
     *
     * @return \RTMTrade\OpenCart\AdminApi\Model\ProductOptionData[]|null
     */
    public function getProductOption()
    {
        return $this->container['productOption'];
    }

    /**
     * Sets productOption
     *
     * @param \RTMTrade\OpenCart\AdminApi\Model\ProductOptionData[]|null $productOption 
     *
     * @return $this
     */
    public function setProductOption($productOption)
    {
        $this->container['productOption'] = $productOption;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


